/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.infrastructure.configuration.yaml;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.hotels.styx.infrastructure.configuration.UnresolvedPlaceholder;
import com.hotels.styx.infrastructure.configuration.yaml.JsonTreeTraversal;
import com.hotels.styx.infrastructure.configuration.yaml.NodePath;
import com.hotels.styx.infrastructure.configuration.yaml.PathElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlaceholderResolver {
    private static final Pattern PLACEHOLDER_REGEX_CAPTURE_ALL = Pattern.compile("(\\$\\{[_a-zA-Z0-9\\[\\]\\.]+(:[^\\}]*?)?\\})");
    private static final Pattern PLACEHOLDER_REGEX_CAPTURE_NAME_AND_DEFAULT = Pattern.compile("\\$\\{([_a-zA-Z0-9\\[\\]\\.]+)(?::([^\\}]*?))?\\}");
    private static final Logger LOGGER = LoggerFactory.getLogger(PlaceholderResolver.class);
    private final ObjectNode rootNode;
    private final Map<String, String> externalProperties;

    public PlaceholderResolver(ObjectNode rootNode, Map<String, String> externalProperties) {
        this.rootNode = Objects.requireNonNull(rootNode);
        this.externalProperties = ImmutableMap.copyOf(externalProperties);
    }

    public static Collection<UnresolvedPlaceholder> resolvePlaceholders(JsonNode rootNode, Map<String, String> externalProperties) {
        if (rootNode.isObject()) {
            return new PlaceholderResolver((ObjectNode)rootNode, externalProperties).resolve();
        }
        return Collections.emptyList();
    }

    public static Collection<UnresolvedPlaceholder> resolvePlaceholders(JsonNode rootNode, Properties properties) {
        return PlaceholderResolver.resolvePlaceholders(rootNode, (Map<String, String>)properties);
    }

    public Collection<UnresolvedPlaceholder> resolve() {
        HashMap resolved = Maps.newHashMap(this.externalProperties);
        ResolutionVisitor visitor = new ResolutionVisitor(resolved);
        while (visitor.passAgain) {
            visitor.passAgain = false;
            JsonTreeTraversal.traverseJsonTree((JsonNode)this.rootNode, visitor);
        }
        JsonTreeTraversal.traverseJsonTree((JsonNode)this.rootNode, new DefaultsVisitor());
        return JsonTreeTraversal.traverseJsonTree((JsonNode)this.rootNode, new UnresolvedPlaceholdersVisitor()).unresolvedPlaceholderDescriptions;
    }

    private static <T> T last(List<T> list) {
        return list.get(list.size() - 1);
    }

    @VisibleForTesting
    public static String replacePlaceholder(String originalString, String placeholderName, String placeholderValue) {
        return originalString.replaceAll("\\$\\{" + Pattern.quote(placeholderName) + "(?:\\:[^\\}]*?)?\\}", placeholderValue);
    }

    @VisibleForTesting
    static List<String> extractPlaceholderStrings(String value) {
        Matcher matcher = PLACEHOLDER_REGEX_CAPTURE_ALL.matcher(value);
        ArrayList<String> placeholders = new ArrayList<String>();
        while (matcher.find()) {
            placeholders.add(matcher.group());
        }
        return placeholders;
    }

    @VisibleForTesting
    public static List<Placeholder> extractPlaceholders(String value) {
        ArrayList<Placeholder> namesAndDefaults = new ArrayList<Placeholder>();
        for (String placeholder : PlaceholderResolver.extractPlaceholderStrings(value)) {
            Matcher placeholderMatcher = PLACEHOLDER_REGEX_CAPTURE_NAME_AND_DEFAULT.matcher(placeholder);
            if (!placeholderMatcher.matches()) continue;
            namesAndDefaults.add(new Placeholder(placeholderMatcher.group(1), placeholderMatcher.group(2)));
        }
        return namesAndDefaults;
    }

    public static class Placeholder {
        private final String name;
        private final Optional<String> defaultValue;

        Placeholder(String name, Optional<String> defaultValue) {
            this.name = name;
            this.defaultValue = defaultValue;
        }

        Placeholder(String name, String defaultValue) {
            this(name, Optional.ofNullable(defaultValue));
        }

        Placeholder(String name) {
            this(name, Optional.empty());
        }

        public String name() {
            return this.name;
        }

        public boolean hasDefaultValue() {
            return this.defaultValue.isPresent();
        }

        public String defaultValue() {
            return this.defaultValue.get();
        }

        public String toString() {
            if (this.defaultValue.isPresent()) {
                return "${" + this.name + ":" + this.defaultValue.get() + "}";
            }
            return "${" + this.name + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Placeholder that = (Placeholder)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.defaultValue, that.defaultValue);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.defaultValue);
        }
    }

    private static class UnresolvedPlaceholdersVisitor
    implements JsonTreeTraversal.JsonTreeVisitor {
        private final Collection<UnresolvedPlaceholder> unresolvedPlaceholderDescriptions = new ArrayList<UnresolvedPlaceholder>();

        private UnresolvedPlaceholdersVisitor() {
        }

        @Override
        public void onValueNode(ValueNode node, Optional<ContainerNode<?>> parent, List<PathElement> path) {
            String value = node.isTextual() ? node.textValue() : node.toString();
            List<String> placeholders = PlaceholderResolver.extractPlaceholderStrings(value);
            if (!placeholders.isEmpty()) {
                String pathString = new NodePath(path).toString();
                for (String placeholder : placeholders) {
                    this.unresolvedPlaceholderDescriptions.add(new UnresolvedPlaceholder(pathString, value, placeholder));
                }
            }
        }
    }

    private static class DefaultsVisitor
    implements JsonTreeTraversal.JsonTreeVisitor {
        private DefaultsVisitor() {
        }

        @Override
        public void onValueNode(ValueNode node, Optional<ContainerNode<?>> parent, List<PathElement> path) {
            String value = node.isTextual() ? node.textValue() : node.toString();
            List<Placeholder> placeholders = PlaceholderResolver.extractPlaceholders(value);
            if (!placeholders.isEmpty()) {
                for (Placeholder placeholder : placeholders) {
                    if (!placeholder.hasDefaultValue()) continue;
                    String valueWithReplacements = PlaceholderResolver.replacePlaceholder(value, placeholder.name(), placeholder.defaultValue());
                    ((PathElement)PlaceholderResolver.last(path)).setChild((JsonNode)parent.get(), (JsonNode)TextNode.valueOf((String)valueWithReplacements));
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("At {}, replaced {} with {}", new Object[]{path, value, valueWithReplacements});
                }
            }
        }
    }

    private static class ResolutionVisitor
    implements JsonTreeTraversal.JsonTreeVisitor {
        private final Map<String, String> resolved;
        private boolean passAgain = true;

        public ResolutionVisitor(Map<String, String> resolved) {
            this.resolved = resolved;
        }

        @Override
        public void onValueNode(ValueNode node, Optional<ContainerNode<?>> parent, List<PathElement> pathAsList) {
            String path = new NodePath(pathAsList).toString();
            String value = node.isTextual() ? node.textValue() : node.toString();
            List<Placeholder> placeholders = PlaceholderResolver.extractPlaceholders(value);
            if (placeholders.isEmpty() && !this.resolved.containsKey(path)) {
                this.resolved.put(path, value);
                this.passAgain = true;
            } else {
                boolean changes = false;
                for (Placeholder placeholder : placeholders) {
                    String replacement = this.resolved.get(placeholder.name());
                    if (replacement == null) continue;
                    String valueWithReplacements = PlaceholderResolver.replacePlaceholder(value, placeholder.name(), replacement);
                    ((PathElement)PlaceholderResolver.last(pathAsList)).setChild((JsonNode)parent.get(), (JsonNode)TextNode.valueOf((String)valueWithReplacements));
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("At {}, replaced {} with {}", new Object[]{pathAsList, value, valueWithReplacements});
                    }
                    value = valueWithReplacements;
                    changes = true;
                }
                this.passAgain |= changes;
            }
        }
    }
}

