/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.infrastructure.configuration.yaml;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotels.styx.api.configuration.ConversionException;
import com.hotels.styx.infrastructure.configuration.ExtensibleConfiguration;
import com.hotels.styx.infrastructure.configuration.UnresolvedPlaceholder;
import com.hotels.styx.infrastructure.configuration.yaml.NodePath;
import com.hotels.styx.infrastructure.configuration.yaml.PlaceholderResolver;
import com.hotels.styx.infrastructure.configuration.yaml.YamlConfigurationFormat;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YamlConfiguration
implements ExtensibleConfiguration<YamlConfiguration> {
    private static final Logger LOGGER = LoggerFactory.getLogger(YamlConfigurationFormat.class);
    private final JsonNode rootNode;

    public YamlConfiguration(JsonNode rootNode) {
        this.rootNode = Objects.requireNonNull(rootNode);
    }

    @Override
    public YamlConfiguration withParent(YamlConfiguration parent) {
        return new YamlConfiguration(YamlConfiguration.merge(parent.rootNode.deepCopy(), this.rootNode));
    }

    @Override
    public YamlConfiguration withOverrides(Map<String, String> overrides) {
        JsonNode newRootNode = this.rootNode.deepCopy();
        YamlConfiguration.applyExternalOverrides(newRootNode, overrides);
        return new YamlConfiguration(newRootNode);
    }

    @Override
    public ExtensibleConfiguration.PlaceholderResolutionResult<YamlConfiguration> resolvePlaceholders(Map<String, String> overrides) {
        JsonNode newRootNode = this.rootNode.deepCopy();
        Collection<UnresolvedPlaceholder> unresolvedPlaceholders = PlaceholderResolver.resolvePlaceholders(newRootNode, overrides);
        return new ExtensibleConfiguration.PlaceholderResolutionResult<YamlConfiguration>(new YamlConfiguration(newRootNode), unresolvedPlaceholders);
    }

    public <T> Optional<T> get(String property, Class<T> tClass) {
        return this.nodeAt(property).map(node -> {
            if (tClass == Path.class) {
                return Paths.get(node.textValue(), new String[0]);
            }
            return YamlConfiguration.parseNodeToClass(node, tClass);
        });
    }

    public <X> X as(Class<X> type) throws ConversionException {
        return YamlConfiguration.parseNodeToClass(this.rootNode, type);
    }

    public String toString() {
        return this.rootNode.toString();
    }

    public JsonNode root() {
        return this.rootNode;
    }

    private static JsonNode merge(JsonNode baseNode, JsonNode overrideNode) {
        Iterable fieldNames = () -> ((JsonNode)overrideNode).fieldNames();
        for (String fieldName : fieldNames) {
            JsonNode jsonNode = baseNode.get(fieldName);
            if (jsonNode != null && jsonNode.isObject()) {
                YamlConfiguration.merge(jsonNode, overrideNode.get(fieldName));
                continue;
            }
            if (!(baseNode instanceof ObjectNode)) continue;
            JsonNode value = overrideNode.get(fieldName);
            ((ObjectNode)baseNode).put(fieldName, value);
        }
        return baseNode;
    }

    private static void applyExternalOverrides(JsonNode rootNode, Map<String, String> overrides) {
        overrides.forEach((key, value) -> {
            NodePath nodePath = new NodePath((String)key);
            nodePath.override(rootNode, (String)value);
        });
    }

    private Optional<JsonNode> nodeAt(String property) {
        NodePath nodePath = new NodePath(property);
        return nodePath.findMatchingDescendant(this.rootNode);
    }

    private static <T> T parseNodeToClass(JsonNode node, Class<T> tClass) {
        JsonParser parser = node.traverse();
        try {
            return (T)YamlConfigurationFormat.YAML_MAPPER.readValue(parser, tClass);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

