/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.infrastructure.configuration.yaml;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.hotels.styx.api.Resource;
import com.hotels.styx.infrastructure.configuration.ConfigurationFormat;
import com.hotels.styx.infrastructure.configuration.json.ObjectMappers;
import com.hotels.styx.infrastructure.configuration.yaml.PlaceholderResolver;
import com.hotels.styx.infrastructure.configuration.yaml.YamlConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YamlConfigurationFormat
implements ConfigurationFormat<YamlConfiguration> {
    public static final YamlConfigurationFormat YAML = new YamlConfigurationFormat();
    private static final Logger LOGGER = LoggerFactory.getLogger(YamlConfigurationFormat.class);
    static final ObjectMapper YAML_MAPPER = ObjectMappers.addStyxMixins(new ObjectMapper((JsonFactory)new YAMLFactory())).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, true);

    private YamlConfigurationFormat() {
    }

    @Override
    public YamlConfiguration deserialise(String string) {
        return new YamlConfiguration(YamlConfigurationFormat.node(string));
    }

    @Override
    public YamlConfiguration deserialise(Resource resource) {
        return new YamlConfiguration(YamlConfigurationFormat.node(resource));
    }

    private static JsonNode node(String yaml) {
        try {
            return YAML_MAPPER.readTree(yaml);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static JsonNode node(Resource resource) {
        LOGGER.info("Loading configuration from file: path={}", (Object)resource);
        try (InputStream inputStream = resource.inputStream();){
            JsonNode jsonNode = YAML_MAPPER.readTree(inputStream);
            return jsonNode;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String resolvePlaceholdersInText(String text, Map<String, String> overrides) {
        List<PlaceholderResolver.Placeholder> placeholders = PlaceholderResolver.extractPlaceholders(text);
        String resolvedText = text;
        for (PlaceholderResolver.Placeholder placeholder : placeholders) {
            resolvedText = YamlConfigurationFormat.resolvePlaceholderInText(resolvedText, placeholder, overrides);
        }
        return resolvedText;
    }

    private static String resolvePlaceholderInText(String textValue, PlaceholderResolver.Placeholder placeholder, Map<String, String> overrides) {
        String placeholderName = placeholder.name();
        String override = overrides.get(placeholderName);
        if (override != null) {
            return PlaceholderResolver.replacePlaceholder(textValue, placeholderName, override);
        }
        if (placeholder.hasDefaultValue()) {
            return PlaceholderResolver.replacePlaceholder(textValue, placeholderName, placeholder.defaultValue());
        }
        throw new IllegalStateException("Cannot resolve placeholder '" + placeholder + "' in include:" + textValue);
    }

    public String toString() {
        return "YAML";
    }
}

