/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.infrastructure.logging;

import ch.qos.logback.classic.pattern.ClassicConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.CoreConstants;
import com.google.common.base.Charsets;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.hotels.styx.common.Strings;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class ExceptionConverter
extends ClassicConverter {
    public static final String TARGET_CLASSES_PROPERTY_NAME = "targetclasses";
    private static final String SPLUNK_FRIENDLY_LOG_MESSAGE_TEMPLATE = "[exceptionClass={0}, exceptionMethod={1}, exceptionID={2}]" + CoreConstants.LINE_SEPARATOR;
    private static final String[] TARGET_CLASSES_DEFAULT = new String[]{"com.hotels.styx"};
    private static final int MAXIMUM_ALLOWED_DEPTH = 10;
    private static final HashFunction MD5_HASHING = Hashing.md5();
    private static final String NO_MSG = "";

    public String convert(ILoggingEvent loggingEvent) {
        return Optional.ofNullable(loggingEvent).map(this::getExceptionData).orElse(NO_MSG);
    }

    private String getExceptionData(ILoggingEvent loggingEvent) {
        IThrowableProxy throwableProxy = loggingEvent.getThrowableProxy();
        StackTraceElementProxy loggableStackTraceElement = this.findFirstStackTraceElementForClasses(throwableProxy, this.readStyxClassesFromProperty()).orElse(this.getTopStackTraceElement(throwableProxy));
        return Optional.ofNullable(loggableStackTraceElement).map(ExceptionConverter::createExceptionMessage).orElse(NO_MSG);
    }

    private static String createExceptionMessage(StackTraceElementProxy loggableStackTraceElement) {
        String exceptionClass = loggableStackTraceElement.getStackTraceElement().getClassName();
        String exceptionMethod = loggableStackTraceElement.getStackTraceElement().getMethodName();
        String exceptionID = ExceptionConverter.hashCodeForException(exceptionClass, exceptionMethod);
        return MessageFormat.format(SPLUNK_FRIENDLY_LOG_MESSAGE_TEMPLATE, exceptionClass, exceptionMethod, exceptionID);
    }

    private Optional<StackTraceElementProxy> findFirstStackTraceElementForClasses(IThrowableProxy throwableProxy, String[] targetClasses) {
        return StreamSupport.stream(this.collectThrowableProxies(throwableProxy).spliterator(), false).flatMap(proxy -> proxy != null ? Arrays.stream(proxy.getStackTraceElementProxyArray()) : Stream.empty()).filter(steProxy -> ExceptionConverter.contains(steProxy.getSTEAsString(), targetClasses)).findFirst();
    }

    private String[] readStyxClassesFromProperty() {
        String[] targetClasses = TARGET_CLASSES_DEFAULT;
        Context ctx = this.getContext();
        String property = ctx.getProperty(TARGET_CLASSES_PROPERTY_NAME);
        if (Strings.isNotEmpty((String)property)) {
            targetClasses = (String[])Arrays.stream(property.split(",")).map(String::trim).toArray(String[]::new);
        } else {
            this.addError(MessageFormat.format("The '{0}' property should be present on logback configuration. Using default classname prefixes.", TARGET_CLASSES_PROPERTY_NAME));
        }
        return targetClasses;
    }

    private Iterable<IThrowableProxy> collectThrowableProxies(IThrowableProxy throwableProxy) {
        IThrowableProxy[] throwableProxyArray = new IThrowableProxy[10];
        IThrowableProxy actualThrowableProxy = throwableProxy;
        for (int i = 0; i < throwableProxyArray.length && actualThrowableProxy != null; actualThrowableProxy = actualThrowableProxy.getCause(), ++i) {
            throwableProxyArray[i] = actualThrowableProxy;
        }
        return Arrays.asList(throwableProxyArray);
    }

    private StackTraceElementProxy getTopStackTraceElement(IThrowableProxy throwableProxy) {
        StackTraceElementProxy stackTraceLine = null;
        StackTraceElementProxy[] stackTraceElementProxyArray = throwableProxy.getStackTraceElementProxyArray();
        if (stackTraceElementProxyArray != null && stackTraceElementProxyArray.length > 0) {
            stackTraceLine = stackTraceElementProxyArray[0];
        }
        return stackTraceLine;
    }

    private static boolean contains(String stackTraceLine, String[] targetClasses) {
        boolean retValue = false;
        for (String targetClass : targetClasses) {
            if (!stackTraceLine.contains(targetClass)) continue;
            retValue = true;
            break;
        }
        return retValue;
    }

    private static String hashCodeForException(String exceptionClass, String exceptionMethod) {
        String hashString = exceptionClass + exceptionMethod;
        int md5Hash = MD5_HASHING.newHasher().putString((CharSequence)hashString, Charsets.UTF_8).hash().asInt();
        return Integer.toHexString(md5Hash);
    }
}

