/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.infrastructure.logging;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.selector.ContextSelector;
import ch.qos.logback.classic.util.ContextInitializer;
import ch.qos.logback.classic.util.ContextSelectorStaticBinder;
import ch.qos.logback.core.joran.spi.JoranException;
import com.hotels.styx.common.Logging;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.slf4j.bridge.SLF4JBridgeHandler;
import org.slf4j.impl.StaticLoggerBinder;

public final class LOGBackConfigurer {
    private static final String PLACEHOLDER_PREFIX = "${";
    private static final String PLACEHOLDER_SUFFIX = "}";
    private static final String CLASSPATH_URL_PREFIX = "classpath:";
    private static final String FILE_URL_PREFIX = "file:";

    private LOGBackConfigurer() {
    }

    public static void initLogging(String logConfigLocation, boolean installJULBridge) {
        try {
            String location = LOGBackConfigurer.resolvePlaceholders(logConfigLocation);
            if (location.indexOf(PLACEHOLDER_PREFIX) >= 0) {
                throw new IllegalStateException("unable to resolve certain placeholders: " + Logging.sanitise((String)location));
            }
            location = location.replaceAll("\\\\", "/");
            String notice = "If you are watching the console output, it may stop after this point, if configured to only write to file.";
            Logger.getLogger(LOGBackConfigurer.class.getName()).info("Initializing LOGBack from [" + Logging.sanitise((String)location) + "]. " + notice);
            LOGBackConfigurer.initLogging(LOGBackConfigurer.getURL(location), installJULBridge);
        }
        catch (FileNotFoundException ex) {
            throw new IllegalArgumentException("invalid '" + Logging.sanitise((String)logConfigLocation) + "' parameter: " + ex.getMessage());
        }
    }

    public static void initLogging(URL url, boolean installJULBridge) {
        StaticLoggerBinder.getSingleton();
        ContextSelector selector = ContextSelectorStaticBinder.getSingleton().getContextSelector();
        LoggerContext loggerContext = selector.getLoggerContext();
        loggerContext.stop();
        ContextInitializer ctxi = new ContextInitializer(loggerContext);
        try {
            ctxi.configureByResource(url);
            loggerContext.start();
            if (installJULBridge) {
                Logger l = LogManager.getLogManager().getLogger("");
                for (Handler h : l.getHandlers()) {
                    l.removeHandler(h);
                }
                SLF4JBridgeHandler.install();
            }
        }
        catch (JoranException e) {
            throw new IllegalArgumentException("exception while initializing LOGBack", e);
        }
    }

    public static void shutdownLogging(boolean uninstallJULBridge) {
        ContextSelector selector = ContextSelectorStaticBinder.getSingleton().getContextSelector();
        LoggerContext loggerContext = selector.getLoggerContext();
        String loggerContextName = loggerContext.getName();
        LoggerContext context = selector.detachLoggerContext(loggerContextName);
        if (uninstallJULBridge) {
            SLF4JBridgeHandler.uninstall();
        }
        context.stop();
    }

    private static String resolvePlaceholders(String text) {
        StringBuilder buf = new StringBuilder(text);
        int startIndex = text.indexOf(PLACEHOLDER_PREFIX);
        while (startIndex != -1) {
            int endIndex = buf.indexOf(PLACEHOLDER_SUFFIX, startIndex + PLACEHOLDER_PREFIX.length());
            if (endIndex != -1) {
                String placeholder = buf.substring(startIndex + PLACEHOLDER_PREFIX.length(), endIndex);
                int nextIndex = endIndex + PLACEHOLDER_SUFFIX.length();
                String propVal = System.getProperty(placeholder);
                if (propVal == null) {
                    propVal = System.getenv(placeholder);
                }
                if (propVal != null) {
                    buf.replace(startIndex, endIndex + PLACEHOLDER_SUFFIX.length(), propVal);
                    nextIndex = startIndex + propVal.length();
                }
                startIndex = buf.indexOf(PLACEHOLDER_PREFIX, nextIndex);
                continue;
            }
            startIndex = -1;
        }
        return buf.toString();
    }

    private static URL getURL(String resourceLocation) throws FileNotFoundException {
        URL url;
        if (resourceLocation.startsWith(CLASSPATH_URL_PREFIX)) {
            String path = resourceLocation.substring(CLASSPATH_URL_PREFIX.length());
            url = LOGBackConfigurer.getDefaultClassLoader().getResource(path);
            if (url == null) {
                String description = "class path resource [" + path + "]";
                throw new FileNotFoundException(description + " cannot be resolved to URL because it does not exist");
            }
        } else {
            try {
                url = new URL(resourceLocation);
            }
            catch (MalformedURLException ex) {
                try {
                    url = new URL(FILE_URL_PREFIX + resourceLocation);
                }
                catch (MalformedURLException ex2) {
                    throw new FileNotFoundException("Resource location [" + resourceLocation + "] is neither a URL not a well-formed file path");
                }
            }
        }
        return url;
    }

    private static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable ex) {
            cl = LOGBackConfigurer.class.getClassLoader();
        }
        if (cl == null) {
            cl = LOGBackConfigurer.class.getClassLoader();
        }
        return cl;
    }
}

