/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.metrics.reporting.graphite;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class GraphiteConfig {
    private final String host;
    private final int port;
    private final long intervalMillis;
    private final String prefix;

    @JsonCreator
    GraphiteConfig(@JsonProperty(value="host") String host, @JsonProperty(value="port") Integer port, @JsonProperty(value="intervalMillis") Long intervalMillis, @JsonProperty(value="prefix") String prefix) {
        this.host = host;
        this.port = Optional.ofNullable(port).orElse(9090);
        this.intervalMillis = Optional.ofNullable(intervalMillis).orElse(TimeUnit.SECONDS.toMillis(5L));
        this.prefix = Optional.ofNullable(prefix).orElse("");
    }

    @JsonProperty(value="prefix")
    public String prefix() {
        return this.prefix;
    }

    @JsonProperty(value="host")
    public String host() {
        return this.host;
    }

    @JsonProperty(value="port")
    public int port() {
        return this.port;
    }

    @JsonProperty(value="intervalMillis")
    public long intervalMillis() {
        return this.intervalMillis;
    }

    public String toString() {
        return new StringBuilder(96).append(this.getClass().getSimpleName()).append("{host=").append(this.host).append(", port=").append(this.port).append(", intervalMillis=").append(this.intervalMillis).append('}').toString();
    }
}

