/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.metrics.reporting.graphite;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metered;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.codahale.metrics.graphite.GraphiteSender;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.hotels.styx.metrics.reporting.graphite.IOAction;
import com.hotels.styx.metrics.reporting.graphite.IoRetry;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Locale;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphiteReporter
extends ScheduledReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphiteReporter.class);
    @VisibleForTesting
    static final int MAX_RETRIES = 5;
    private final GraphiteSender graphite;
    private final Clock clock;
    private final String prefix;
    private final LoadingCache<String, String> counterPrefixes = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, String>(){

        public String load(String name) {
            return GraphiteReporter.this.prefix(new String[]{name, "count"});
        }
    });
    private final LoadingCache<String, String> gaugePrefixes = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, String>(){

        public String load(String name) {
            return GraphiteReporter.this.prefix(new String[]{name});
        }
    });
    private final LoadingCache<String, HistogramPrefixes> histogramPrefixes = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, HistogramPrefixes>(){

        public HistogramPrefixes load(String name) {
            return new HistogramPrefixes(name);
        }
    });
    private final LoadingCache<String, MeteredPrefixes> meteredPrefixes = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, MeteredPrefixes>(){

        public MeteredPrefixes load(String name) {
            return new MeteredPrefixes(name);
        }
    });
    private final LoadingCache<String, TimerPrefixes> timerPrefixes = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, TimerPrefixes>(){

        public TimerPrefixes load(String name) {
            return new TimerPrefixes(name);
        }
    });

    public static Builder forRegistry(MetricRegistry registry) {
        return new Builder(registry);
    }

    private GraphiteReporter(MetricRegistry registry, GraphiteSender graphite, Clock clock, String prefix, TimeUnit rateUnit, TimeUnit durationUnit, MetricFilter filter) {
        super(registry, "graphite-reporter", filter, rateUnit, durationUnit);
        this.graphite = graphite;
        this.clock = clock;
        this.prefix = prefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        long timestamp = this.clock.getTime() / 1000L;
        try {
            this.initConnection();
            gauges.forEach((name, gauge) -> this.doReport((String)name, (Metric)gauge, timestamp, this::reportGauge));
            counters.forEach((name, counter) -> this.doReport((String)name, (Metric)counter, timestamp, this::reportCounter));
            histograms.forEach((name, histogram) -> this.doReport((String)name, (Metric)histogram, timestamp, this::reportHistogram));
            meters.forEach((name, meter) -> this.doReport((String)name, (Metric)meter, timestamp, this::reportMetered));
            timers.forEach((name, timer) -> this.doReport((String)name, (Metric)timer, timestamp, this::reportTimer));
            this.graphite.flush();
        }
        catch (Exception e) {
            LOGGER.error("Error reporting metrics" + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                this.graphite.close();
            }
            catch (IOException e1) {
                LOGGER.warn("Error closing Graphite", (Object)this.graphite, (Object)e1);
            }
        }
    }

    private <M extends Metric> void doReport(String name, M metric, long timestamp, MetricReportingAction<M> consumer) {
        try {
            consumer.execute(name, metric, timestamp);
        }
        catch (UncheckedIOException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("Error reporting metric '" + name + "': " + e.getMessage(), (Throwable)e);
        }
    }

    @VisibleForTesting
    void initConnection() {
        IoRetry.tryTimes(5, () -> ((GraphiteSender)this.graphite).connect(), e -> GraphiteReporter.attemptErrorHandling(() -> this.graphite.close()));
    }

    private void reconnectIfNecessary(Throwable e) {
        if (e instanceof IOException) {
            GraphiteReporter.attemptErrorHandling(() -> this.graphite.close());
            GraphiteReporter.attemptErrorHandling(() -> ((GraphiteSender)this.graphite).connect());
        } else if (e.getCause() != null) {
            this.reconnectIfNecessary(e.getCause());
        }
    }

    private static void attemptErrorHandling(IOAction action) {
        try {
            action.run();
        }
        catch (Exception e) {
            LOGGER.error("Error during error handling: ", (Throwable)e);
        }
    }

    public void stop() {
        try {
            super.stop();
        }
        finally {
            try {
                this.graphite.close();
            }
            catch (IOException e) {
                LOGGER.debug("Error disconnecting from Graphite", (Object)this.graphite, (Object)e);
            }
        }
    }

    private void reportTimer(String name, Timer timer, long timestamp) {
        Snapshot snapshot = timer.getSnapshot();
        TimerPrefixes timerPrefixes = (TimerPrefixes)this.timerPrefixes.getUnchecked((Object)name);
        this.doSend(timerPrefixes.max, this.convertDuration(snapshot.getMax()), timestamp);
        this.doSend(timerPrefixes.mean, this.convertDuration(snapshot.getMean()), timestamp);
        this.doSend(timerPrefixes.min, this.convertDuration(snapshot.getMin()), timestamp);
        this.doSend(timerPrefixes.stddev, this.convertDuration(snapshot.getStdDev()), timestamp);
        this.doSend(timerPrefixes.p50, this.convertDuration(snapshot.getMedian()), timestamp);
        this.doSend(timerPrefixes.p75, this.convertDuration(snapshot.get75thPercentile()), timestamp);
        this.doSend(timerPrefixes.p95, this.convertDuration(snapshot.get95thPercentile()), timestamp);
        this.doSend(timerPrefixes.p98, this.convertDuration(snapshot.get98thPercentile()), timestamp);
        this.doSend(timerPrefixes.p99, this.convertDuration(snapshot.get99thPercentile()), timestamp);
        this.doSend(timerPrefixes.p999, this.convertDuration(snapshot.get999thPercentile()), timestamp);
        this.reportMetered(name, (Metered)timer, timestamp);
    }

    private void reportMetered(String name, Metered meter, long timestamp) {
        MeteredPrefixes meteredPrefixes = (MeteredPrefixes)this.meteredPrefixes.getUnchecked((Object)name);
        this.doSend(meteredPrefixes.count, meter.getCount(), timestamp);
        this.doSend(meteredPrefixes.m1_rate, this.convertRate(meter.getOneMinuteRate()), timestamp);
        this.doSend(meteredPrefixes.m5_rate, this.convertRate(meter.getFiveMinuteRate()), timestamp);
        this.doSend(meteredPrefixes.m15_rate, this.convertRate(meter.getFifteenMinuteRate()), timestamp);
        this.doSend(meteredPrefixes.mean_rate, this.convertRate(meter.getMeanRate()), timestamp);
    }

    private void reportHistogram(String name, Histogram histogram, long timestamp) {
        Snapshot snapshot = histogram.getSnapshot();
        HistogramPrefixes histogramPrefixes = (HistogramPrefixes)this.histogramPrefixes.getUnchecked((Object)name);
        this.doSend(histogramPrefixes.count, histogram.getCount(), timestamp);
        this.doSend(histogramPrefixes.max, snapshot.getMax(), timestamp);
        this.doSend(histogramPrefixes.mean, snapshot.getMean(), timestamp);
        this.doSend(histogramPrefixes.min, snapshot.getMin(), timestamp);
        this.doSend(histogramPrefixes.stddev, snapshot.getStdDev(), timestamp);
        this.doSend(histogramPrefixes.p50, snapshot.getMedian(), timestamp);
        this.doSend(histogramPrefixes.p75, snapshot.get75thPercentile(), timestamp);
        this.doSend(histogramPrefixes.p95, snapshot.get95thPercentile(), timestamp);
        this.doSend(histogramPrefixes.p98, snapshot.get98thPercentile(), timestamp);
        this.doSend(histogramPrefixes.p99, snapshot.get99thPercentile(), timestamp);
        this.doSend(histogramPrefixes.p999, snapshot.get999thPercentile(), timestamp);
    }

    private void reportCounter(String name, Counter counter, long timestamp) {
        String counterPrefix = (String)this.counterPrefixes.getUnchecked((Object)name);
        this.doSend(counterPrefix, counter.getCount(), timestamp);
    }

    private void reportGauge(String name, Gauge gauge, long timestamp) {
        String value = this.format(gauge.getValue());
        if (value != null) {
            String gaugePrefix = (String)this.gaugePrefixes.getUnchecked((Object)name);
            this.doSend(gaugePrefix, value, timestamp);
        }
    }

    private void doSend(String name, long value, long timestamp) {
        this.doSend(name, this.format(value), timestamp);
    }

    private void doSend(String name, double value, long timestamp) {
        this.doSend(name, this.format(value), timestamp);
    }

    private void doSend(String name, String value, long timestamp) {
        this.attemptWithRetryAndReconect(() -> this.graphite.send(name, value, timestamp));
    }

    private void attemptWithRetryAndReconect(IOAction operation) {
        IoRetry.tryTimes(5, operation, this::reconnectIfNecessary);
    }

    private String format(Object o) {
        if (o instanceof Float) {
            return this.format(((Float)o).doubleValue());
        }
        if (o instanceof Double) {
            return this.format((Double)o);
        }
        if (o instanceof Byte) {
            return this.format(((Byte)o).longValue());
        }
        if (o instanceof Short) {
            return this.format(((Short)o).longValue());
        }
        if (o instanceof Integer) {
            return this.format(((Integer)o).longValue());
        }
        if (o instanceof Long) {
            return this.format((Long)o);
        }
        if (o instanceof Boolean) {
            return this.format((Boolean)o != false ? 1L : 0L);
        }
        return null;
    }

    private String prefix(String ... components) {
        return MetricRegistry.name((String)this.prefix, (String[])components);
    }

    private String format(long n) {
        return Long.toString(n);
    }

    private String format(double v) {
        return String.format(Locale.US, "%2.2f", v);
    }

    private final class TimerPrefixes {
        private final String max;
        private final String mean;
        private final String min;
        private final String stddev;
        private final String p50;
        private final String p75;
        private final String p95;
        private final String p98;
        private final String p99;
        private final String p999;

        private TimerPrefixes(String name) {
            this.max = GraphiteReporter.this.prefix(new String[]{name, "max"});
            this.mean = GraphiteReporter.this.prefix(new String[]{name, "mean"});
            this.min = GraphiteReporter.this.prefix(new String[]{name, "min"});
            this.stddev = GraphiteReporter.this.prefix(new String[]{name, "stddev"});
            this.p50 = GraphiteReporter.this.prefix(new String[]{name, "p50"});
            this.p75 = GraphiteReporter.this.prefix(new String[]{name, "p75"});
            this.p95 = GraphiteReporter.this.prefix(new String[]{name, "p95"});
            this.p98 = GraphiteReporter.this.prefix(new String[]{name, "p98"});
            this.p99 = GraphiteReporter.this.prefix(new String[]{name, "p99"});
            this.p999 = GraphiteReporter.this.prefix(new String[]{name, "p999"});
        }
    }

    private final class MeteredPrefixes {
        private final String count;
        private final String m1_rate;
        private final String m5_rate;
        private final String m15_rate;
        private final String mean_rate;

        private MeteredPrefixes(String name) {
            this.count = GraphiteReporter.this.prefix(new String[]{name, "count"});
            this.m1_rate = GraphiteReporter.this.prefix(new String[]{name, "m1_rate"});
            this.m5_rate = GraphiteReporter.this.prefix(new String[]{name, "m5_rate"});
            this.m15_rate = GraphiteReporter.this.prefix(new String[]{name, "m15_rate"});
            this.mean_rate = GraphiteReporter.this.prefix(new String[]{name, "mean_rate"});
        }
    }

    private final class HistogramPrefixes {
        private final String count;
        private final String max;
        private final String mean;
        private final String min;
        private final String stddev;
        private final String p50;
        private final String p75;
        private final String p95;
        private final String p98;
        private final String p99;
        private final String p999;

        private HistogramPrefixes(String name) {
            this.count = GraphiteReporter.this.prefix(new String[]{name, "count"});
            this.max = GraphiteReporter.this.prefix(new String[]{name, "max"});
            this.mean = GraphiteReporter.this.prefix(new String[]{name, "mean"});
            this.min = GraphiteReporter.this.prefix(new String[]{name, "min"});
            this.stddev = GraphiteReporter.this.prefix(new String[]{name, "stddev"});
            this.p50 = GraphiteReporter.this.prefix(new String[]{name, "p50"});
            this.p75 = GraphiteReporter.this.prefix(new String[]{name, "p75"});
            this.p95 = GraphiteReporter.this.prefix(new String[]{name, "p95"});
            this.p98 = GraphiteReporter.this.prefix(new String[]{name, "p98"});
            this.p99 = GraphiteReporter.this.prefix(new String[]{name, "p99"});
            this.p999 = GraphiteReporter.this.prefix(new String[]{name, "p999"});
        }
    }

    private static interface MetricReportingAction<M> {
        public void execute(String var1, M var2, long var3);
    }

    public static class Builder {
        private final MetricRegistry registry;
        private Clock clock;
        private String prefix;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private MetricFilter filter;

        private Builder(MetricRegistry registry) {
            this.registry = registry;
            this.clock = Clock.defaultClock();
            this.prefix = null;
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.filter = MetricFilter.ALL;
        }

        public Builder withClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder prefixedWith(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.filter = filter;
            return this;
        }

        public GraphiteReporter build(GraphiteSender graphite) {
            return new GraphiteReporter(this.registry, graphite, this.clock, this.prefix, this.rateUnit, this.durationUnit, this.filter);
        }
    }
}

