/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.metrics.reporting.graphite;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.graphite.GraphiteSender;
import com.google.common.annotations.VisibleForTesting;
import com.hotels.styx.api.extension.service.spi.AbstractStyxService;
import com.hotels.styx.metrics.reporting.graphite.GraphiteReporter;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GraphiteReporterService
extends AbstractStyxService {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphiteReporterService.class);
    private final GraphiteReporter reporter;
    private final long reportingIntervalMillis;

    private GraphiteReporterService(Builder builder) {
        super(Objects.requireNonNull(builder.serviceName));
        MetricRegistry registry = Objects.requireNonNull(builder.registry);
        GraphiteSender graphiteSender = Objects.requireNonNull(builder.graphiteSender);
        String prefix = Objects.requireNonNull(builder.prefix);
        this.reportingIntervalMillis = builder.reportingIntervalMillis;
        this.reporter = GraphiteReporter.forRegistry(registry).prefixedWith(prefix).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).filter(MetricFilter.ALL).build(graphiteSender);
    }

    protected CompletableFuture<Void> startService() {
        return CompletableFuture.runAsync(() -> {
            this.reporter.start(this.reportingIntervalMillis, TimeUnit.MILLISECONDS);
            LOGGER.info("Graphite service started, service name=\"{}\"", (Object)this.serviceName());
        });
    }

    protected CompletableFuture<Void> stopService() {
        return CompletableFuture.runAsync(() -> {
            this.reporter.stop();
            LOGGER.info("Graphite service stopped, service name=\"{}\"", (Object)this.serviceName());
        });
    }

    @VisibleForTesting
    void report() {
        this.reporter.report();
    }

    public static final class Builder {
        private String serviceName;
        private String prefix;
        private long reportingIntervalMillis;
        private MetricRegistry registry;
        private GraphiteSender graphiteSender;

        public Builder metricRegistry(MetricRegistry registry) {
            this.registry = registry;
            return this;
        }

        public Builder serviceName(String name) {
            this.serviceName = name;
            return this;
        }

        public Builder graphiteSender(GraphiteSender graphiteSender) {
            this.graphiteSender = graphiteSender;
            return this;
        }

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder reportingInterval(long reportingInterval, TimeUnit timeUnit) {
            this.reportingIntervalMillis = timeUnit.toMillis(reportingInterval);
            return this;
        }

        public GraphiteReporterService build() {
            return new GraphiteReporterService(this);
        }
    }
}

