/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.metrics.reporting.graphite;

import com.codahale.metrics.graphite.GraphiteSender;
import com.hotels.styx.api.Environment;
import com.hotels.styx.api.configuration.Configuration;
import com.hotels.styx.api.configuration.ServiceFactory;
import com.hotels.styx.api.extension.service.spi.StyxService;
import com.hotels.styx.metrics.reporting.MetricRegistryConstraints;
import com.hotels.styx.metrics.reporting.graphite.GraphiteConfig;
import com.hotels.styx.metrics.reporting.graphite.GraphiteReporterService;
import com.hotels.styx.metrics.reporting.graphite.NonSanitizingGraphiteSender;
import java.util.concurrent.TimeUnit;

public class GraphiteReporterServiceFactory
implements ServiceFactory<StyxService> {
    public StyxService create(Environment environment, Configuration serviceConfiguration) {
        GraphiteConfig graphiteConfig = (GraphiteConfig)serviceConfiguration.as(GraphiteConfig.class);
        String host = graphiteConfig.host();
        int port = graphiteConfig.port();
        return new GraphiteReporterService.Builder().serviceName(String.format("Graphite-Reporter-%s:%d", host, port)).prefix(graphiteConfig.prefix()).graphiteSender((GraphiteSender)new NonSanitizingGraphiteSender(host, port)).reportingInterval(graphiteConfig.intervalMillis(), TimeUnit.MILLISECONDS).metricRegistry(MetricRegistryConstraints.codaHaleMetricRegistry(environment)).build();
    }
}

