/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.metrics.reporting.graphite;

import com.hotels.styx.metrics.reporting.graphite.GraphiteReporter;
import com.hotels.styx.metrics.reporting.graphite.IOAction;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class IoRetry {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphiteReporter.class);

    public static void tryTimes(int times, IOAction task, Consumer<IOException> errorHandler) throws UncheckedIOException, IllegalArgumentException {
        if (times < 1) {
            throw new IllegalArgumentException("The number of retries should be a positive integer. It was " + times);
        }
        int retries = 0;
        while (true) {
            try {
                task.run();
                return;
            }
            catch (IOException e) {
                IoRetry.onError(errorHandler, e);
                if (++retries != times) continue;
                throw new UncheckedIOException(String.format("Operation failed after %d retries: %s", times, e.getMessage()), e);
            }
            break;
        }
    }

    private static void onError(Consumer<IOException> consumer, IOException failure) {
        try {
            consumer.accept(failure);
        }
        catch (Exception e) {
            LOGGER.warn("OnError block for I/O operation failed: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private IoRetry() {
    }
}

