/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.metrics.reporting.sets;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import com.sun.management.OperatingSystemMXBean;
import com.sun.management.UnixOperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public final class OperatingSystemMetricSet
implements MetricSet {
    private final OperatingSystemMXBean bean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();

    public Map<String, Metric> getMetrics() {
        HashMap<String, Gauge> gauges = new HashMap<String, Gauge>();
        OperatingSystemMetricSet.castIfInstance(this.bean, UnixOperatingSystemMXBean.class).ifPresent(unixBean -> {
            gauges.put("fileDescriptors.max", unixBean::getMaxFileDescriptorCount);
            gauges.put("fileDescriptors.open", unixBean::getOpenFileDescriptorCount);
        });
        gauges.put("process.cpu.load", this.bean::getProcessCpuLoad);
        gauges.put("process.cpu.time", this.bean::getProcessCpuTime);
        gauges.put("system.cpu.load", this.bean::getSystemCpuLoad);
        gauges.put("memory.physical.free", this.bean::getFreePhysicalMemorySize);
        gauges.put("memory.physical.total", this.bean::getTotalPhysicalMemorySize);
        gauges.put("memory.virtual.committed", this.bean::getCommittedVirtualMemorySize);
        gauges.put("swapSpace.free", this.bean::getFreeSwapSpaceSize);
        gauges.put("swapSpace.total", this.bean::getTotalSwapSpaceSize);
        return OperatingSystemMetricSet.rawCast(gauges);
    }

    private static <K, V> Map<K, V> rawCast(Map<?, ?> gauges) {
        return gauges;
    }

    private static <T> Optional<T> castIfInstance(Object o, Class<T> type) {
        return type.isInstance(o) ? Optional.of(type.cast(o)) : Optional.empty();
    }
}

