/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.proxy;

import com.google.common.collect.Iterables;
import com.hotels.styx.Environment;
import com.hotels.styx.NettyExecutor;
import com.hotels.styx.api.Eventual;
import com.hotels.styx.api.HttpHandler;
import com.hotels.styx.api.HttpInterceptor;
import com.hotels.styx.api.Id;
import com.hotels.styx.api.LiveHttpRequest;
import com.hotels.styx.api.LiveHttpResponse;
import com.hotels.styx.api.MetricRegistry;
import com.hotels.styx.api.extension.service.BackendService;
import com.hotels.styx.api.extension.service.ConnectionPoolSettings;
import com.hotels.styx.api.extension.service.HealthCheckConfig;
import com.hotels.styx.api.extension.service.TlsSettings;
import com.hotels.styx.api.extension.service.spi.Registry;
import com.hotels.styx.client.BackendServiceClient;
import com.hotels.styx.client.Connection;
import com.hotels.styx.client.HttpClient;
import com.hotels.styx.client.HttpConfig;
import com.hotels.styx.client.HttpRequestOperationFactory;
import com.hotels.styx.client.OriginStatsFactory;
import com.hotels.styx.client.OriginsInventory;
import com.hotels.styx.client.StyxHostHttpClient;
import com.hotels.styx.client.StyxHttpClient;
import com.hotels.styx.client.connectionpool.ConnectionPool;
import com.hotels.styx.client.connectionpool.ExpiringConnectionFactory;
import com.hotels.styx.client.connectionpool.SimpleConnectionPoolFactory;
import com.hotels.styx.client.healthcheck.OriginHealthCheckFunction;
import com.hotels.styx.client.healthcheck.OriginHealthStatusMonitor;
import com.hotels.styx.client.healthcheck.OriginHealthStatusMonitorFactory;
import com.hotels.styx.client.healthcheck.UrlRequestHealthCheck;
import com.hotels.styx.client.netty.connectionpool.NettyConnectionFactory;
import com.hotels.styx.proxy.BackendServiceClientFactory;
import com.hotels.styx.server.HttpRouter;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackendServicesRouter
implements HttpRouter,
Registry.ChangeListener<BackendService> {
    private static final Logger LOG = LoggerFactory.getLogger(BackendServicesRouter.class);
    private final BackendServiceClientFactory clientFactory;
    private final Environment environment;
    private final NettyExecutor executor;
    private final ConcurrentMap<String, ProxyToClientPipeline> routes;

    public BackendServicesRouter(BackendServiceClientFactory clientFactory, Environment environment, NettyExecutor executor) {
        this.clientFactory = Objects.requireNonNull(clientFactory);
        this.environment = Objects.requireNonNull(environment);
        this.executor = Objects.requireNonNull(executor);
        this.routes = new ConcurrentSkipListMap<String, ProxyToClientPipeline>(Comparator.comparingInt(String::length).reversed().thenComparing(Comparator.naturalOrder()));
    }

    ConcurrentMap<String, ProxyToClientPipeline> routes() {
        return this.routes;
    }

    public Optional<HttpHandler> route(LiveHttpRequest request, HttpInterceptor.Context ignore) {
        String path = request.path();
        return this.routes.entrySet().stream().filter(entry -> path.startsWith((String)entry.getKey())).findFirst().map(Map.Entry::getValue);
    }

    public void onChange(Registry.Changes<BackendService> changes) {
        changes.removed().forEach(backendService -> ((ProxyToClientPipeline)this.routes.remove(backendService.path())).close());
        Iterables.concat((Iterable)changes.added(), (Iterable)changes.updated()).forEach(backendService -> {
            ProxyToClientPipeline pipeline = (ProxyToClientPipeline)this.routes.get(backendService.path());
            if (pipeline != null) {
                pipeline.close();
            }
            boolean requestLoggingEnabled = this.environment.styxConfig().get("request-logging.outbound.enabled", Boolean.class).orElse(false);
            boolean longFormat = this.environment.styxConfig().get("request-logging.outbound.longFormat", Boolean.class).orElse(false);
            MetricRegistry originsMetrics = this.environment.metricRegistry().scope("origins");
            OriginStatsFactory.CachingOriginStatsFactory originStatsFactory = new OriginStatsFactory.CachingOriginStatsFactory(originsMetrics);
            ConnectionPoolSettings poolSettings = backendService.connectionPoolConfig();
            Connection.Factory connectionFactory = this.connectionFactory((BackendService)backendService, requestLoggingEnabled, longFormat, (OriginStatsFactory)originStatsFactory, poolSettings.connectionExpirationSeconds());
            SimpleConnectionPoolFactory connectionPoolFactory = new SimpleConnectionPoolFactory.Builder().connectionFactory(connectionFactory).connectionPoolSettings(backendService.connectionPoolConfig()).metricRegistry(originsMetrics).build();
            OriginHealthStatusMonitor healthStatusMonitor = this.healthStatusMonitor((BackendService)backendService);
            OriginsInventory inventory = new OriginsInventory.Builder(backendService.id()).eventBus(this.environment.eventBus()).metricsRegistry(originsMetrics).connectionPoolFactory((ConnectionPool.Factory)connectionPoolFactory).originHealthMonitor(healthStatusMonitor).initialOrigins(backendService.origins()).hostClientFactory(StyxHostHttpClient::create).build();
            pipeline = new ProxyToClientPipeline(this.newClientHandler((BackendService)backendService, inventory, (OriginStatsFactory)originStatsFactory), () -> {
                inventory.close();
                healthStatusMonitor.stop();
            });
            this.routes.put(backendService.path(), pipeline);
            LOG.info("added path={} current routes={}", (Object)backendService.path(), this.routes.keySet());
        });
    }

    private OriginHealthStatusMonitor healthStatusMonitor(BackendService backendService) {
        return new OriginHealthStatusMonitorFactory().create(backendService.id(), backendService.healthCheckConfig(), () -> BackendServicesRouter.originHealthCheckFunction(backendService.id(), this.environment.metricRegistry(), backendService.healthCheckConfig()), (HttpClient)this.healthCheckClient(backendService));
    }

    private StyxHttpClient healthCheckClient(BackendService backendService) {
        StyxHttpClient.Builder builder = new StyxHttpClient.Builder().connectTimeout(backendService.connectionPoolConfig().connectTimeoutMillis(), TimeUnit.MILLISECONDS).userAgent("Styx/" + this.environment.buildInfo().releaseVersion());
        backendService.tlsSettings().ifPresent(arg_0 -> ((StyxHttpClient.Builder)builder).tlsSettings(arg_0));
        return builder.build();
    }

    private Connection.Factory connectionFactory(BackendService backendService, boolean requestLoggingEnabled, boolean longFormat, OriginStatsFactory originStatsFactory, long connectionExpiration) {
        NettyConnectionFactory factory = new NettyConnectionFactory.Builder().executor(this.executor).httpRequestOperationFactory(HttpRequestOperationFactory.Builder.httpRequestOperationFactoryBuilder().flowControlEnabled(true).originStatsFactory(originStatsFactory).responseTimeoutMillis(backendService.responseTimeoutMillis()).requestLoggingEnabled(requestLoggingEnabled).longFormat(longFormat).httpMessageFormatter(this.environment.httpMessageFormatter()).build()).tlsSettings((TlsSettings)backendService.tlsSettings().orElse(null)).httpConfig(HttpConfig.newHttpConfigBuilder().setMaxHeadersSize(backendService.maxHeaderSize()).build()).build();
        if (connectionExpiration > 0L) {
            return new ExpiringConnectionFactory(connectionExpiration, (Connection.Factory)factory);
        }
        return factory;
    }

    private HttpHandler newClientHandler(BackendService backendService, OriginsInventory originsInventory, OriginStatsFactory originStatsFactory) {
        BackendServiceClient client2 = this.clientFactory.createClient(backendService, originsInventory, originStatsFactory);
        return (request, context) -> new Eventual(client2.sendRequest(request, context));
    }

    private static OriginHealthCheckFunction originHealthCheckFunction(Id appId, MetricRegistry metricRegistry, HealthCheckConfig healthCheckConfig) {
        String healthCheckUri = (String)healthCheckConfig.uri().orElseThrow(() -> new IllegalArgumentException("Health check URI missing for " + appId));
        return new UrlRequestHealthCheck(healthCheckUri, metricRegistry);
    }

    private static class ProxyToClientPipeline
    implements HttpHandler {
        private final HttpHandler client;
        private final Runnable onClose;

        ProxyToClientPipeline(HttpHandler httpClient, Runnable onClose) {
            this.client = Objects.requireNonNull(httpClient);
            this.onClose = Objects.requireNonNull(onClose);
        }

        public Eventual<LiveHttpResponse> handle(LiveHttpRequest request, HttpInterceptor.Context context) {
            return this.client.handle(request, context);
        }

        public void close() {
            this.onClose.run();
        }
    }
}

