/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.proxy;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Objects;

public final class ClassFactories {
    private ClassFactories() {
    }

    public static <T> T newInstance(String className, Class<T> type) {
        try {
            Object instance = ClassFactories.classForName(className).newInstance();
            return type.cast(instance);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(String.format("No such class '%s'", className));
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    private static Class<?> classForName(String className) throws ClassNotFoundException {
        Objects.requireNonNull(className);
        PrivilegedAction<String> privilegedAction = () -> className;
        return Class.forName(AccessController.doPrivileged(privilegedAction));
    }
}

