/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.proxy;

import com.hotels.styx.api.HttpResponseStatus;
import com.hotels.styx.api.LiveHttpRequest;
import com.hotels.styx.api.LiveHttpResponse;
import com.hotels.styx.common.format.HttpMessageFormatter;
import com.hotels.styx.server.HttpErrorStatusListener;
import java.net.InetSocketAddress;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpErrorStatusCauseLogger
implements HttpErrorStatusListener {
    private static final Logger LOG = LoggerFactory.getLogger(HttpErrorStatusCauseLogger.class);
    private final HttpMessageFormatter formatter;

    public HttpErrorStatusCauseLogger(HttpMessageFormatter formatter) {
        this.formatter = Objects.requireNonNull(formatter);
    }

    public void proxyErrorOccurred(HttpResponseStatus status, Throwable cause) {
        if (status.code() > 500) {
            LOG.error("Failure status=\"{}\", exception=\"{}\"", (Object)status, (Object)HttpErrorStatusCauseLogger.withoutStackTrace(cause));
        } else {
            LOG.error("Failure status=\"{}\"", (Object)status, (Object)cause);
        }
    }

    public void proxyErrorOccurred(LiveHttpRequest request, InetSocketAddress clientAddress, HttpResponseStatus status, Throwable cause) {
        if (status.code() == 500) {
            LOG.error("Failure status=\"{}\" during request={}, clientAddress={}", new Object[]{status, this.formatter.formatRequest(request), clientAddress, cause});
        } else {
            this.proxyErrorOccurred(status, cause);
        }
    }

    public void proxyErrorOccurred(Throwable cause) {
        LOG.error("Error occurred during proxying", cause);
    }

    public void proxyWriteFailure(LiveHttpRequest request, LiveHttpResponse response, Throwable cause) {
        LOG.error("Error writing response. request={}, response={}, cause={}", new Object[]{this.formatter.formatRequest(request), this.formatter.formatResponse(response), cause});
    }

    public void proxyingFailure(LiveHttpRequest request, LiveHttpResponse response, Throwable cause) {
        LOG.error("Error proxying request. request={} response={} cause={}", new Object[]{this.formatter.formatRequest(request), this.formatter.formatResponse(response), cause});
    }

    private static String withoutStackTrace(Throwable cause) {
        StringBuilder builder = new StringBuilder(cause.toString());
        Throwable head = cause;
        while ((head = head.getCause()) != null) {
            builder.append(", cause=").append('\"').append(head).append('\"');
        }
        return builder.toString();
    }
}

