/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.proxy;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.hotels.styx.api.HttpResponseStatus;
import com.hotels.styx.api.LiveHttpRequest;
import com.hotels.styx.api.LiveHttpResponse;
import com.hotels.styx.api.MetricRegistry;
import com.hotels.styx.api.plugins.spi.PluginException;
import com.hotels.styx.server.HttpErrorStatusListener;
import java.net.InetSocketAddress;
import java.util.Objects;

public class HttpErrorStatusMetrics
implements HttpErrorStatusListener {
    private final MetricRegistry metricRegistry;
    private final Meter styxErrors;

    public HttpErrorStatusMetrics(MetricRegistry metricRegistry) {
        this.metricRegistry = Objects.requireNonNull(metricRegistry);
        this.preregisterMetrics();
        this.styxErrors = metricRegistry.meter("styx.errors");
    }

    public void proxyErrorOccurred(HttpResponseStatus status, Throwable cause) {
        this.record(status);
        if (HttpErrorStatusMetrics.isError(status)) {
            this.incrementExceptionCounter(cause, status);
        }
    }

    public void proxyErrorOccurred(Throwable cause) {
        this.incrementExceptionCounter(cause);
    }

    public void proxyErrorOccurred(LiveHttpRequest request, InetSocketAddress clientAddress, HttpResponseStatus status, Throwable cause) {
        this.proxyErrorOccurred(status, cause);
    }

    public void proxyWriteFailure(LiveHttpRequest request, LiveHttpResponse response, Throwable cause) {
        this.incrementExceptionCounter(cause, response.status());
    }

    public void proxyingFailure(LiveHttpRequest request, LiveHttpResponse response, Throwable cause) {
        this.incrementExceptionCounter(cause, response.status());
    }

    private void incrementExceptionCounter(Throwable cause) {
        this.incrementExceptionCounter(cause, null);
    }

    private void incrementExceptionCounter(Throwable cause, HttpResponseStatus status) {
        if (!(cause instanceof PluginException)) {
            if (HttpResponseStatus.INTERNAL_SERVER_ERROR.equals(status)) {
                this.styxErrors.mark();
            }
            this.exceptionCounter(cause).inc();
        }
    }

    private Counter exceptionCounter(Throwable exception) {
        return this.metricRegistry.counter("styx.exception." + HttpErrorStatusMetrics.formattedExceptionName(exception.getClass()));
    }

    static String formattedExceptionName(Class<? extends Throwable> type) {
        return type.getName().replace('.', '_');
    }

    private static boolean isError(HttpResponseStatus status) {
        return status.code() >= 400;
    }

    private void record(HttpResponseStatus status) {
        if (HttpErrorStatusMetrics.isError(status)) {
            this.metricRegistry.counter("styx.response.status." + status.code()).inc();
        }
    }

    private void preregisterMetrics() {
        this.metricRegistry.counter("styx.response.status.200");
        this.metricRegistry.counter("styx.exception." + HttpErrorStatusMetrics.formattedExceptionName(Exception.class));
    }
}

