/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.proxy;

import com.google.common.collect.ImmutableList;
import com.hotels.styx.Environment;
import com.hotels.styx.api.HttpInterceptor;
import com.hotels.styx.proxy.plugin.InstrumentedPlugin;
import com.hotels.styx.proxy.plugin.NamedPlugin;
import com.hotels.styx.routing.RoutingObject;
import com.hotels.styx.routing.handlers.HttpInterceptorPipeline;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class InterceptorPipelineBuilder {
    private final Environment environment;
    private final Iterable<NamedPlugin> plugins;
    private final RoutingObject handler;
    private final boolean trackRequests;

    public InterceptorPipelineBuilder(Environment environment, Iterable<NamedPlugin> plugins, RoutingObject handler, boolean trackRequests) {
        this.environment = Objects.requireNonNull(environment);
        this.plugins = Objects.requireNonNull(plugins);
        this.handler = Objects.requireNonNull(handler);
        this.trackRequests = trackRequests;
    }

    public RoutingObject build() {
        ImmutableList interceptors = ImmutableList.copyOf(InterceptorPipelineBuilder.instrument(this.plugins, this.environment));
        return new HttpInterceptorPipeline((List<HttpInterceptor>)interceptors, this.handler, this.trackRequests);
    }

    private static List<InstrumentedPlugin> instrument(Iterable<NamedPlugin> namedPlugins, Environment environment) {
        return StreamSupport.stream(namedPlugins.spliterator(), false).map(namedPlugin -> new InstrumentedPlugin((NamedPlugin)namedPlugin, environment)).collect(Collectors.toList());
    }
}

