/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.proxy;

import com.hotels.styx.api.configuration.Configuration;
import com.hotels.styx.api.configuration.MissingConfigurationException;
import com.hotels.styx.api.extension.loadbalancing.spi.LoadBalancerFactory;
import com.hotels.styx.client.loadbalancing.strategies.BusyConnectionsStrategy;
import com.hotels.styx.proxy.ClassFactories;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadBalancingStrategyFactoryProvider
implements Supplier<LoadBalancerFactory> {
    private static final String LOAD_BALANCING_STRATEGY_KEY = "loadBalancing.strategy";
    private static final LoadBalancerFactory BUSY_CONNECTION_BALANCER = new BusyConnectionsStrategy.Factory();
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadBalancingStrategyFactoryProvider.class);
    private final Configuration configurations;

    public LoadBalancingStrategyFactoryProvider(Configuration configurations) {
        this.configurations = configurations;
    }

    public static LoadBalancingStrategyFactoryProvider newProvider(Configuration configurations) {
        return new LoadBalancingStrategyFactoryProvider(configurations);
    }

    @Override
    public LoadBalancerFactory get() {
        return this.configurations.get(LOAD_BALANCING_STRATEGY_KEY).map(this::newFactoryInstance).orElseGet(this::busyConnectionBalancer);
    }

    private LoadBalancerFactory busyConnectionBalancer() {
        LOGGER.info("No configured load-balancing strategy found. Using {}", (Object)BUSY_CONNECTION_BALANCER);
        return BUSY_CONNECTION_BALANCER;
    }

    private LoadBalancerFactory newFactoryInstance(String strategyName) {
        String factoryClassName = this.factoryClassName(strategyName);
        return ClassFactories.newInstance(factoryClassName, LoadBalancerFactory.class);
    }

    private String factoryClassName(String strategyName) {
        String key = String.format("loadBalancing.strategies.%s.factory.class", strategyName);
        return (String)this.configurations.get(key).orElseThrow(() -> new MissingConfigurationException(key));
    }
}

