/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.proxy;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.hotels.styx.server.HttpConnectorConfig;
import com.hotels.styx.server.HttpsConnectorConfig;
import com.hotels.styx.server.netty.NettyServerConfig;

@JsonDeserialize(builder=Builder.class)
public class ProxyServerConfig
extends NettyServerConfig {
    private final int clientWorkerThreadsCount;

    public ProxyServerConfig() {
        this.clientWorkerThreadsCount = HALF_OF_AVAILABLE_PROCESSORS;
    }

    private ProxyServerConfig(Builder builder) {
        super(builder.builder);
        Integer clientThreads = builder.clientWorkerThreadsCount;
        this.clientWorkerThreadsCount = clientThreads == null || clientThreads == 0 ? HALF_OF_AVAILABLE_PROCESSORS : clientThreads;
    }

    public int clientWorkerThreadsCount() {
        return this.clientWorkerThreadsCount;
    }

    @JsonPOJOBuilder(withPrefix="set")
    public static class Builder {
        private final NettyServerConfig.Builder builder = new NettyServerConfig.Builder();
        private Integer clientWorkerThreadsCount;

        @JsonProperty(value="bossThreadsCount")
        public Builder setBossThreadsCount(Integer bossThreadsCount) {
            this.builder.setBossThreadsCount(bossThreadsCount);
            return this;
        }

        @JsonProperty(value="workerThreadsCount")
        public Builder setWorkerThreadsCount(Integer workerThreadsCount) {
            this.builder.setWorkerThreadsCount(workerThreadsCount);
            return this;
        }

        @JsonProperty(value="nioAcceptorBacklog")
        public Builder setNioAcceptorBacklog(Integer nioAcceptorBacklog) {
            this.builder.setNioAcceptorBacklog(nioAcceptorBacklog);
            return this;
        }

        @JsonProperty(value="maxInitialLength")
        public Builder setMaxInitialLength(Integer maxInitialLength) {
            this.builder.setMaxInitialLength(maxInitialLength);
            return this;
        }

        @JsonProperty(value="maxHeaderSize")
        public Builder setMaxHeaderSize(Integer maxHeaderSize) {
            this.builder.setMaxHeaderSize(maxHeaderSize);
            return this;
        }

        @JsonProperty(value="maxChunkSize")
        public Builder setMaxChunkSize(Integer maxChunkSize) {
            this.builder.setMaxChunkSize(maxChunkSize);
            return this;
        }

        @JsonProperty(value="requestTimeoutMillis")
        public Builder setRequestTimeoutMillis(Integer requestTimeoutMillis) {
            this.builder.setRequestTimeoutMs(requestTimeoutMillis);
            return this;
        }

        @JsonProperty(value="keepAliveTimeoutMillis")
        public Builder setKeepAliveTimeoutMillis(Integer keepAliveTimeoutMillis) {
            this.builder.setKeepAliveTimeoutMillis(keepAliveTimeoutMillis);
            return this;
        }

        @JsonProperty(value="connectors")
        public Builder setConnectors(NettyServerConfig.Connectors connectors) {
            this.builder.setConnectors(connectors);
            return this;
        }

        public Builder setHttpConnector(HttpConnectorConfig httpConnector) {
            this.builder.setHttpConnector(httpConnector);
            return this;
        }

        public Builder setHttpsConnector(HttpsConnectorConfig httpsConnector) {
            this.builder.setHttpsConnector(httpsConnector);
            return this;
        }

        @JsonProperty(value="maxConnectionsCount")
        public Builder setMaxConnectionsCount(Integer maxConnectionsCount) {
            this.builder.setMaxConnectionsCount(maxConnectionsCount);
            return this;
        }

        @JsonProperty(value="clientWorkerThreadsCount")
        public Builder setClientWorkerThreadsCount(Integer clientWorkerThreadsCount) {
            this.clientWorkerThreadsCount = clientWorkerThreadsCount;
            return this;
        }

        @JsonProperty(value="compressResponses")
        public Builder setCompressResponses(boolean compressResponses) {
            this.builder.setCompressResponses(compressResponses);
            return this;
        }

        public ProxyServerConfig build() {
            if (this.clientWorkerThreadsCount == null || this.clientWorkerThreadsCount == 0) {
                this.clientWorkerThreadsCount = NettyServerConfig.HALF_OF_AVAILABLE_PROCESSORS;
            }
            return new ProxyServerConfig(this);
        }
    }
}

