/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.proxy;

import com.codahale.metrics.Meter;
import com.hotels.styx.api.MetricRegistry;
import com.hotels.styx.common.SimpleCache;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;

public class ServerProtocolDistributionRecorder
extends ChannelDuplexHandler {
    private final Meter requests;
    private final SimpleCache<HttpResponseStatus, Meter> responses;

    public ServerProtocolDistributionRecorder(MetricRegistry metricRegistry, boolean secure) {
        this.requests = metricRegistry.meter("styx.server." + ServerProtocolDistributionRecorder.protocolName(secure) + ".requests");
        this.responses = new SimpleCache(status -> metricRegistry.meter("styx.server." + ServerProtocolDistributionRecorder.protocolName(secure) + ".responses." + status.code()));
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpRequest) {
            this.requests.mark();
        }
        super.channelRead(ctx, msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof HttpResponse) {
            ((Meter)this.responses.get((Object)((HttpResponse)msg).status())).mark();
        }
        super.write(ctx, msg, promise);
    }

    private static String protocolName(boolean secure) {
        return secure ? "https" : "http";
    }
}

