/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.proxy;

import com.hotels.styx.Environment;
import com.hotels.styx.StyxConfig;
import com.hotels.styx.api.extension.ActiveOrigins;
import com.hotels.styx.api.extension.OriginsChangeListener;
import com.hotels.styx.api.extension.loadbalancing.spi.LoadBalancer;
import com.hotels.styx.api.extension.retrypolicy.spi.RetryPolicy;
import com.hotels.styx.api.extension.service.BackendService;
import com.hotels.styx.client.BackendServiceClient;
import com.hotels.styx.client.OriginRestrictionLoadBalancingStrategy;
import com.hotels.styx.client.OriginStatsFactory;
import com.hotels.styx.client.OriginsInventory;
import com.hotels.styx.client.StyxBackendServiceClient;
import com.hotels.styx.client.loadbalancing.strategies.BusyConnectionsStrategy;
import com.hotels.styx.client.retry.RetryNTimes;
import com.hotels.styx.client.stickysession.StickySessionLoadBalancingStrategy;
import com.hotels.styx.proxy.BackendServiceClientFactory;
import com.hotels.styx.serviceproviders.ServiceProvision;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StyxBackendServiceClientFactory
implements BackendServiceClientFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(BackendServiceClientFactory.class);
    private final Environment environment;

    public StyxBackendServiceClientFactory(Environment environment) {
        this.environment = environment;
    }

    @Override
    public BackendServiceClient createClient(BackendService backendService, OriginsInventory originsInventory, OriginStatsFactory originStatsFactory) {
        StyxConfig styxConfig = this.environment.configuration();
        String originRestrictionCookie = styxConfig.get("originRestrictionCookie").orElse(null);
        boolean stickySessionEnabled = backendService.stickySessionConfig().stickySessionEnabled();
        RetryPolicy retryPolicy = ServiceProvision.loadRetryPolicy(styxConfig, this.environment, "retrypolicy.policy.factory", RetryPolicy.class).orElseGet(() -> StyxBackendServiceClientFactory.defaultRetryPolicy(this.environment));
        LoadBalancer configuredLbStrategy = ServiceProvision.loadLoadBalancer(styxConfig, this.environment, "loadBalancing.strategy.factory", LoadBalancer.class, (ActiveOrigins)originsInventory).orElseGet(() -> new BusyConnectionsStrategy((ActiveOrigins)originsInventory));
        originsInventory.addOriginsChangeListener((OriginsChangeListener)configuredLbStrategy);
        LoadBalancer loadBalancingStrategy = this.decorateLoadBalancer(configuredLbStrategy, stickySessionEnabled, originsInventory, originRestrictionCookie);
        return new StyxBackendServiceClient.Builder(backendService.id()).loadBalancer(loadBalancingStrategy).stickySessionConfig(backendService.stickySessionConfig()).metricsRegistry(this.environment.metricRegistry()).retryPolicy(retryPolicy).rewriteRules(backendService.rewrites()).originStatsFactory(originStatsFactory).originsRestrictionCookieName(originRestrictionCookie).originIdHeader(this.environment.styxConfig().styxHeaderConfig().originIdHeaderName()).build();
    }

    private LoadBalancer decorateLoadBalancer(LoadBalancer configuredLbStrategy, boolean stickySessionEnabled, OriginsInventory originsInventory, String originRestrictionCookie) {
        if (stickySessionEnabled) {
            return new StickySessionLoadBalancingStrategy((ActiveOrigins)originsInventory, configuredLbStrategy);
        }
        if (originRestrictionCookie == null) {
            LOGGER.info("originRestrictionCookie not specified - origin restriction disabled");
            return configuredLbStrategy;
        }
        LOGGER.info("originRestrictionCookie specified as {} - origin restriction will apply when this cookie is sent", (Object)originRestrictionCookie);
        return new OriginRestrictionLoadBalancingStrategy((ActiveOrigins)originsInventory, configuredLbStrategy);
    }

    private static RetryPolicy defaultRetryPolicy(com.hotels.styx.api.Environment environment) {
        RetryNTimes retryOnce = new RetryNTimes(1);
        LOGGER.warn("No configured retry policy found in {}. Using {}", (Object)environment.configuration(), (Object)retryOnce);
        return retryOnce;
    }
}

