/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.proxy.backends.file;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.annotations.VisibleForTesting;
import com.hotels.styx.api.Environment;
import com.hotels.styx.api.Resource;
import com.hotels.styx.api.configuration.Configuration;
import com.hotels.styx.api.configuration.ConfigurationException;
import com.hotels.styx.api.extension.service.BackendService;
import com.hotels.styx.api.extension.service.spi.AbstractStyxService;
import com.hotels.styx.api.extension.service.spi.Registry;
import com.hotels.styx.applications.BackendServices;
import com.hotels.styx.common.io.ResourceFactory;
import com.hotels.styx.infrastructure.FileBackedRegistry;
import com.hotels.styx.infrastructure.configuration.json.ObjectMappers;
import com.hotels.styx.proxy.backends.file.FileChangeMonitor;
import com.hotels.styx.proxy.backends.file.FileMonitor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBackedBackendServicesRegistry
extends AbstractStyxService
implements Registry<BackendService>,
FileMonitor.Listener {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileBackedBackendServicesRegistry.class);
    private final FileBackedRegistry<BackendService> fileBackedRegistry;
    private final FileMonitor fileChangeMonitor;

    @VisibleForTesting
    FileBackedBackendServicesRegistry(FileBackedRegistry<BackendService> fileBackedRegistry, FileMonitor fileChangeMonitor) {
        super(String.format("FileBackedBackendServiceRegistry(%s)", fileBackedRegistry.fileName()));
        this.fileBackedRegistry = Objects.requireNonNull(fileBackedRegistry);
        this.fileChangeMonitor = Objects.requireNonNull(fileChangeMonitor);
    }

    @VisibleForTesting
    FileBackedBackendServicesRegistry(Resource originsFile, FileMonitor fileChangeMonitor) {
        this(new FileBackedRegistry<BackendService>(originsFile, new YAMLBackendServicesReader(), new RejectDuplicatePaths()), fileChangeMonitor);
    }

    public static FileBackedBackendServicesRegistry create(String originsFile) {
        return new FileBackedBackendServicesRegistry(ResourceFactory.newResource((String)originsFile), FileMonitor.DISABLED);
    }

    public Registry<BackendService> addListener(Registry.ChangeListener<BackendService> changeListener) {
        return this.fileBackedRegistry.addListener(changeListener);
    }

    public Registry<BackendService> removeListener(Registry.ChangeListener<BackendService> changeListener) {
        return this.fileBackedRegistry.removeListener(changeListener);
    }

    public CompletableFuture<Registry.ReloadResult> reload() {
        return this.fileBackedRegistry.reload().thenApply(outcome -> this.logReloadAttempt("Admin Interface", (Registry.ReloadResult)outcome));
    }

    public Iterable<BackendService> get() {
        return this.fileBackedRegistry.get();
    }

    protected CompletableFuture<Void> startService() {
        try {
            this.fileChangeMonitor.start(this);
        }
        catch (Exception e) {
            CompletableFuture<Void> x = new CompletableFuture<Void>();
            x.completeExceptionally(e);
            return x;
        }
        return ((CompletableFuture)this.fileBackedRegistry.reload().thenApply(result2 -> this.logReloadAttempt("Initial load", (Registry.ReloadResult)result2))).thenAccept(result2 -> {
            if (result2.outcome() == Registry.Outcome.FAILED) {
                throw new RuntimeException(result2.cause().orElse(null));
            }
        });
    }

    public CompletableFuture<Void> stop() {
        return super.stop();
    }

    @VisibleForTesting
    FileMonitor monitor() {
        return this.fileChangeMonitor;
    }

    @Override
    public void fileChanged() {
        this.fileBackedRegistry.reload().thenApply(outcome -> this.logReloadAttempt("File Monitor", (Registry.ReloadResult)outcome));
    }

    private Registry.ReloadResult logReloadAttempt(String reason, Registry.ReloadResult outcome) {
        String fileName = this.fileBackedRegistry.fileName();
        if (outcome.outcome() == Registry.Outcome.RELOADED || outcome.outcome() == Registry.Outcome.UNCHANGED) {
            LOGGER.info("Backend services reloaded. reason='{}', {}, file='{}'", new Object[]{reason, outcome.message(), fileName});
        } else if (outcome.outcome() == Registry.Outcome.FAILED) {
            LOGGER.error("Backend services reload failed. reason='{}', {}, file='{}'", new Object[]{reason, outcome.message(), fileName, outcome.cause().get()});
        }
        return outcome;
    }

    public String toString() {
        return new StringBuilder(32).append(this.getClass().getSimpleName()).append("{originsFileName=").append(this.fileBackedRegistry.fileName()).append('}').toString();
    }

    @VisibleForTesting
    static class RejectDuplicatePaths
    implements Predicate<Collection<BackendService>> {
        RejectDuplicatePaths() {
        }

        @Override
        public boolean test(Collection<BackendService> backendServices) {
            Map<String, List<BackendService>> pathToApp = backendServices.stream().collect(Collectors.groupingBy(BackendService::path));
            List<List<BackendService>> duplicateApps = pathToApp.values().stream().filter(backends -> backends.size() > 1).collect(Collectors.toList());
            if (duplicateApps.size() > 0) {
                LOGGER.error(RejectDuplicatePaths.errorMessage(duplicateApps));
            }
            return duplicateApps.size() == 0;
        }

        private static String errorMessage(List<List<BackendService>> backendServices) {
            return backendServices.stream().map(RejectDuplicatePaths::duplicatePathsErrorForPath).collect(Collectors.joining(", "));
        }

        private static String duplicatePathsErrorForPath(List<BackendService> apps) {
            String path = apps.get(0).path();
            String appsList = apps.stream().map(app -> String.format("'%s'", app.id())).collect(Collectors.joining(", "));
            return String.format("Duplicate path '%s' used for applications: %s", path, appsList);
        }
    }

    @VisibleForTesting
    static class YAMLBackendServicesReader
    implements FileBackedRegistry.Reader<BackendService> {
        private static final ObjectMapper MAPPER = ObjectMappers.addStyxMixins(new ObjectMapper((JsonFactory)new YAMLFactory())).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, true);
        private static final TypeReference<List<BackendService>> TYPE = new TypeReference<List<BackendService>>(){};

        YAMLBackendServicesReader() {
        }

        @Override
        public Iterable<BackendService> read(byte[] content) {
            try {
                JsonNode rootNode = MAPPER.readTree(content);
                List services = (List)MAPPER.readValue(rootNode.traverse(), TYPE);
                return BackendServices.newBackendServices(services);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class Factory
    implements Registry.Factory<BackendService> {
        public Registry<BackendService> create(Environment environment, Configuration registryConfiguration) {
            String originsFile = registryConfiguration.get("originsFile", String.class).map(Factory::requireNonEmpty).orElseThrow(() -> new ConfigurationException("missing [services.registry.factory.config.originsFile] config value for factory class FileBackedBackendServicesRegistry.Factory"));
            FileChangeMonitor.FileMonitorSettings monitorSettings = registryConfiguration.get("monitor", FileChangeMonitor.FileMonitorSettings.class).orElseGet(FileChangeMonitor.FileMonitorSettings::new);
            return Factory.registry(originsFile, monitorSettings);
        }

        private static Registry<BackendService> registry(String originsFile, FileChangeMonitor.FileMonitorSettings monitorSettings) {
            Factory.requireNonEmpty(originsFile);
            FileMonitor monitor = monitorSettings.enabled() ? new FileChangeMonitor(originsFile) : FileMonitor.DISABLED;
            Resource resource = ResourceFactory.newResource((String)originsFile);
            return new FileBackedBackendServicesRegistry(resource, monitor);
        }

        private static String requireNonEmpty(String originsFile) {
            if (originsFile.isEmpty()) {
                throw new ConfigurationException("empty [services.registry.factory.config.originsFile] config value for factory class FileBackedBackendServicesRegistry.Factory");
            }
            return originsFile;
        }
    }
}

