/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.proxy.backends.file;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.hash.HashCode;
import com.hotels.styx.proxy.backends.file.FileMonitor;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileChangeMonitor
implements FileMonitor {
    private final Path monitoredFile;
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private final Duration pollPeriod;
    private final AtomicReference<FileTime> lastChangedTime = new AtomicReference<FileTime>(FileTime.fromMillis(0L));
    private final AtomicReference<HashCode> hashCode = new AtomicReference();
    private final Duration initialDelay;
    private volatile boolean performHashCheck;
    private ScheduledFuture<?> monitoredTask;
    private static final Logger LOGGER = LoggerFactory.getLogger(FileChangeMonitor.class);

    public FileChangeMonitor(String monitoredFile, Duration initialDelay, Duration pollPeriod) {
        FileChangeMonitor.requireExists(Objects.requireNonNull(monitoredFile));
        this.monitoredFile = Paths.get(monitoredFile, new String[0]);
        this.pollPeriod = pollPeriod;
        this.initialDelay = initialDelay;
        this.hashCode.set(HashCode.fromLong((long)0L));
    }

    public FileChangeMonitor(String monitoredFile) {
        this(monitoredFile, Duration.ofMillis(0L), Duration.ofSeconds(1L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(FileMonitor.Listener listener) {
        LOGGER.debug("start, initialDelay={}, pollPeriod={}", new Object[]{this.initialDelay, this.pollPeriod});
        FileChangeMonitor fileChangeMonitor = this;
        synchronized (fileChangeMonitor) {
            if (this.monitoredTask != null) {
                String message = String.format("File monitor for '%s' is already started", this.monitoredFile);
                throw new IllegalStateException(message);
            }
            this.monitoredTask = this.executor.scheduleAtFixedRate(this.detectFileChangesTask(listener), this.initialDelay.toMillis(), this.pollPeriod.toMillis(), TimeUnit.MILLISECONDS);
        }
    }

    public void stop() {
        LOGGER.debug("stop");
        if (this.monitoredTask != null) {
            this.monitoredTask.cancel(true);
        }
    }

    private Runnable detectFileChangesTask(FileMonitor.Listener listener) {
        return () -> {
            LOGGER.debug("Poll {}", (Object)this.monitoredFile);
            if (!Files.exists(this.monitoredFile, new LinkOption[0])) {
                LOGGER.debug("Monitored file does not exist. Path={}", (Object)this.monitoredFile);
            } else if (!Files.isReadable(this.monitoredFile)) {
                LOGGER.debug("Monitored file is no longer readable. Path={}", (Object)this.monitoredFile);
            } else if (this.modificationTimeChanged(this.monitoredFile)) {
                this.hashCode.set(com.hotels.styx.common.Files.fileContentMd5((Path)this.monitoredFile));
                this.performHashCheck = true;
                listener.fileChanged();
            } else if (this.performHashCheck && this.contentHashChanged(this.monitoredFile)) {
                listener.fileChanged();
            }
        };
    }

    private boolean modificationTimeChanged(Path monitoredFile) {
        try {
            FileTime current = Files.getLastModifiedTime(monitoredFile, new LinkOption[0]);
            FileTime previous = this.lastChangedTime.getAndSet(current);
            boolean changed = !previous.equals(current);
            LOGGER.debug("modificationTimeChange probe. Changed={}", (Object)changed);
            return changed;
        }
        catch (IOException e) {
            String message = String.format("Cannot get modification time for Path=%s", monitoredFile);
            throw new RuntimeException(message, e);
        }
    }

    private boolean contentHashChanged(Path monitoredFile) {
        HashCode newHashCode = com.hotels.styx.common.Files.fileContentMd5((Path)monitoredFile);
        boolean changed = !this.hashCode.getAndSet(newHashCode).equals((Object)newHashCode);
        LOGGER.debug("contentHashChanged probe. Changed={}", (Object)changed);
        return changed;
    }

    private static void requireExists(String path) {
        if (!Files.isReadable(Paths.get(path, new String[0]))) {
            throw new IllegalArgumentException(String.format("File '%s' does not exist or is not readable.", path));
        }
    }

    @VisibleForTesting
    static class FileMonitorSettings {
        private final boolean enabled;

        @JsonCreator
        FileMonitorSettings(@JsonProperty(value="enabled") boolean enabled) {
            this.enabled = enabled;
        }

        FileMonitorSettings() {
            this(false);
        }

        boolean enabled() {
            return this.enabled;
        }
    }
}

