/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.proxy.encoders;

import com.google.common.escape.CharEscaperBuilder;
import com.google.common.escape.Escaper;
import com.google.common.escape.Escapers;
import com.hotels.styx.StyxConfig;
import com.hotels.styx.common.Strings;
import com.hotels.styx.server.netty.codec.UnwiseCharsEncoder;
import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurableUnwiseCharsEncoder
implements UnwiseCharsEncoder {
    public static final String ENCODE_UNWISECHARS = "url.encoding.unwiseCharactersToEncode";
    private final Escaper escaper;
    private final Logger logger;

    public ConfigurableUnwiseCharsEncoder(String unwiseChars) {
        this(unwiseChars, LoggerFactory.getLogger(ConfigurableUnwiseCharsEncoder.class));
    }

    public ConfigurableUnwiseCharsEncoder(StyxConfig config) {
        this(config, LoggerFactory.getLogger(ConfigurableUnwiseCharsEncoder.class));
    }

    public ConfigurableUnwiseCharsEncoder(StyxConfig config, Logger logger) {
        this(config.get(ENCODE_UNWISECHARS).orElse(""), logger);
    }

    public ConfigurableUnwiseCharsEncoder(String unwiseChars, Logger logger) {
        this.escaper = ConfigurableUnwiseCharsEncoder.newEscaper(unwiseChars);
        this.logger = Objects.requireNonNull(logger);
    }

    public String encode(String value) {
        String escaped = this.escaper.escape(value);
        if (!Objects.equals(escaped, value)) {
            this.logger.warn("Value contains unwise chars. you should fix this. raw={}, escaped={}: ", (Object)value, (Object)escaped);
        }
        return escaped;
    }

    private static Escaper newEscaper(String unwiseChars) {
        if (Strings.isNullOrEmpty((String)unwiseChars)) {
            return Escapers.nullEscaper();
        }
        CharEscaperBuilder builder = new CharEscaperBuilder();
        Arrays.stream(unwiseChars.split(",")).filter(Strings::isNotEmpty).map(token -> Character.valueOf(token.charAt(0))).forEach(c -> builder.addEscape(c.charValue(), "%" + Integer.toHexString(c.charValue()).toUpperCase()));
        return builder.toEscaper();
    }
}

