/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.proxy.healthchecks;

import com.codahale.metrics.health.HealthCheck;
import com.hotels.styx.api.Clock;
import com.hotels.styx.api.Clocks;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public class HealthCheckTimestamp
extends HealthCheck {
    public static final String NAME = "healthCheckTimestamp";
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private final Clock clock;

    public HealthCheckTimestamp() {
        this(Clocks.systemClock());
    }

    public HealthCheckTimestamp(Clock clock) {
        this.clock = clock;
    }

    protected HealthCheck.Result check() {
        ZonedDateTime now = Instant.ofEpochMilli(this.clock.tickMillis()).atZone(ZoneOffset.UTC);
        return HealthCheck.Result.healthy((String)DATE_TIME_FORMATTER.format(now));
    }
}

