/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.proxy.interceptors;

import com.hotels.styx.api.Eventual;
import com.hotels.styx.api.HttpHeaderNames;
import com.hotels.styx.api.HttpInterceptor;
import com.hotels.styx.api.LiveHttpRequest;
import com.hotels.styx.api.LiveHttpResponse;

public class HopByHopHeadersRemovingInterceptor
implements HttpInterceptor {
    public Eventual<LiveHttpResponse> intercept(LiveHttpRequest request, HttpInterceptor.Chain chain) {
        return chain.proceed(HopByHopHeadersRemovingInterceptor.removeHopByHopHeaders(request)).map(HopByHopHeadersRemovingInterceptor::removeHopByHopHeaders);
    }

    private static LiveHttpResponse removeHopByHopHeaders(LiveHttpResponse response) {
        LiveHttpResponse.Transformer newResponse = response.newBuilder();
        response.header(HttpHeaderNames.CONNECTION).ifPresent(connection -> {
            for (String connectToken : connection.split(",")) {
                String header = connectToken.trim();
                newResponse.removeHeader((CharSequence)header);
            }
            newResponse.removeHeader(HttpHeaderNames.CONNECTION);
        });
        newResponse.removeHeader(HttpHeaderNames.KEEP_ALIVE).removeHeader(HttpHeaderNames.PROXY_AUTHENTICATE).removeHeader(HttpHeaderNames.PROXY_AUTHORIZATION).removeHeader(HttpHeaderNames.TE).removeHeader(HttpHeaderNames.TRAILER).removeHeader(HttpHeaderNames.TRANSFER_ENCODING).removeHeader(HttpHeaderNames.UPGRADE);
        return newResponse.build();
    }

    private static LiveHttpRequest removeHopByHopHeaders(LiveHttpRequest request) {
        LiveHttpRequest.Transformer newRequest = request.newBuilder();
        request.header(HttpHeaderNames.CONNECTION).ifPresent(connection -> {
            for (String connectToken : connection.split(",")) {
                String header = connectToken.trim();
                newRequest.removeHeader((CharSequence)header);
            }
            newRequest.removeHeader(HttpHeaderNames.CONNECTION);
        });
        newRequest.removeHeader(HttpHeaderNames.KEEP_ALIVE).removeHeader(HttpHeaderNames.PROXY_AUTHENTICATE).removeHeader(HttpHeaderNames.PROXY_AUTHORIZATION).removeHeader(HttpHeaderNames.TE).removeHeader(HttpHeaderNames.TRAILER).removeHeader(HttpHeaderNames.UPGRADE);
        return newRequest.build();
    }
}

