/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.proxy.interceptors;

import com.hotels.styx.api.Eventual;
import com.hotels.styx.api.HttpInterceptor;
import com.hotels.styx.api.LiveHttpRequest;
import com.hotels.styx.api.LiveHttpResponse;
import com.hotels.styx.common.format.HttpMessageFormatter;
import com.hotels.styx.common.logging.HttpRequestMessageLogger;

public class HttpMessageLoggingInterceptor
implements HttpInterceptor {
    private final HttpRequestMessageLogger logger;

    public HttpMessageLoggingInterceptor(boolean longFormatEnabled, HttpMessageFormatter httpMessageFormatter) {
        this.logger = new HttpRequestMessageLogger("com.hotels.styx.http-messages.inbound", longFormatEnabled, httpMessageFormatter);
    }

    public Eventual<LiveHttpResponse> intercept(LiveHttpRequest request, HttpInterceptor.Chain chain) {
        boolean secure = chain.context().isSecure();
        this.logger.logRequest(request, null, secure);
        return chain.proceed(request).map(response -> {
            this.logger.logResponse(request, response, secure);
            return response;
        });
    }
}

