/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.proxy.interceptors;

import com.hotels.styx.api.Eventual;
import com.hotels.styx.api.HttpHeaderNames;
import com.hotels.styx.api.HttpInterceptor;
import com.hotels.styx.api.LiveHttpRequest;
import com.hotels.styx.api.LiveHttpResponse;
import com.hotels.styx.client.StyxHeaderConfig;
import java.net.InetSocketAddress;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestEnrichingInterceptor
implements HttpInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestEnrichingInterceptor.class);
    private final CharSequence requestIdHeaderName;

    public RequestEnrichingInterceptor(StyxHeaderConfig styxHeaderConfig) {
        this.requestIdHeaderName = styxHeaderConfig.requestIdHeaderName();
    }

    public Eventual<LiveHttpResponse> intercept(LiveHttpRequest request, HttpInterceptor.Chain chain) {
        return chain.proceed(this.enrich(request, chain.context()));
    }

    private LiveHttpRequest enrich(LiveHttpRequest request, HttpInterceptor.Context context) {
        LiveHttpRequest.Transformer builder = request.newBuilder();
        RequestEnrichingInterceptor.xForwardedFor(request, context).ifPresent(headerValue -> builder.header(HttpHeaderNames.X_FORWARDED_FOR, headerValue));
        return builder.header(this.requestIdHeaderName, request.id()).header(HttpHeaderNames.X_FORWARDED_PROTO, (Object)RequestEnrichingInterceptor.xForwardedProto(request, context.isSecure())).build();
    }

    private static Optional<String> xForwardedFor(LiveHttpRequest request, HttpInterceptor.Context context) {
        Optional<String> maybeClientAddress = context.clientAddress().map(InetSocketAddress::getHostString).map(hostName -> request.header(HttpHeaderNames.X_FORWARDED_FOR).map(xForwardedFor -> xForwardedFor + ", " + hostName).orElse((String)hostName));
        if (!maybeClientAddress.isPresent()) {
            LOGGER.warn("No clientAddress in context url={}", (Object)request.url());
        }
        return maybeClientAddress;
    }

    private static CharSequence xForwardedProto(LiveHttpRequest request, boolean secure) {
        return request.header(HttpHeaderNames.X_FORWARDED_PROTO).orElse(secure ? "https" : "http");
    }
}

