/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.proxy.interceptors;

import com.hotels.styx.api.Eventual;
import com.hotels.styx.api.HttpHeaderNames;
import com.hotels.styx.api.HttpInterceptor;
import com.hotels.styx.api.LiveHttpRequest;
import com.hotels.styx.api.LiveHttpResponse;
import java.util.Optional;

public class UnexpectedRequestContentLengthRemover
implements HttpInterceptor {
    public Eventual<LiveHttpResponse> intercept(LiveHttpRequest request, HttpInterceptor.Chain chain) {
        return chain.proceed(UnexpectedRequestContentLengthRemover.removeBadContentLength(request));
    }

    private static LiveHttpRequest removeBadContentLength(LiveHttpRequest request) {
        Optional contentLength = request.contentLength();
        if (contentLength.isPresent() && request.chunked()) {
            return request.newBuilder().removeHeader(HttpHeaderNames.CONTENT_LENGTH).build();
        }
        return request;
    }
}

