/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.proxy.interceptors;

import com.hotels.styx.api.Eventual;
import com.hotels.styx.api.HttpHeaderNames;
import com.hotels.styx.api.HttpInterceptor;
import com.hotels.styx.api.HttpVersion;
import com.hotels.styx.api.LiveHttpRequest;
import com.hotels.styx.api.LiveHttpResponse;
import com.hotels.styx.common.Strings;
import io.netty.handler.codec.http.HttpHeaders;

public class ViaHeaderAppendingInterceptor
implements HttpInterceptor {
    private static final CharSequence VIA_STYX_1_0 = HttpHeaders.newEntity((String)"1.0 styx");
    private static final CharSequence VIA_STYX_1_1 = HttpHeaders.newEntity((String)"1.1 styx");

    public Eventual<LiveHttpResponse> intercept(LiveHttpRequest request, HttpInterceptor.Chain chain) {
        LiveHttpRequest newRequest = request.newBuilder().header(HttpHeaderNames.VIA, (Object)ViaHeaderAppendingInterceptor.viaHeader(request)).build();
        return chain.proceed(newRequest).map(response -> response.newBuilder().header(HttpHeaderNames.VIA, (Object)ViaHeaderAppendingInterceptor.viaHeader(response)).build());
    }

    private static CharSequence viaHeader(LiveHttpRequest httpMessage) {
        CharSequence styxViaEntry = ViaHeaderAppendingInterceptor.styxViaEntry(httpMessage.version());
        return httpMessage.headers().get(HttpHeaderNames.VIA).map(viaHeader -> Strings.isNotEmpty((String)viaHeader) ? viaHeader + ", " + styxViaEntry : styxViaEntry).orElse(styxViaEntry);
    }

    private static CharSequence viaHeader(LiveHttpResponse httpMessage) {
        CharSequence styxViaEntry = ViaHeaderAppendingInterceptor.styxViaEntry(httpMessage.version());
        return httpMessage.headers().get(HttpHeaderNames.VIA).map(viaHeader -> Strings.isNotEmpty((String)viaHeader) ? viaHeader + ", " + styxViaEntry : styxViaEntry).orElse(styxViaEntry);
    }

    private static CharSequence styxViaEntry(HttpVersion httpVersion) {
        return httpVersion.equals(HttpVersion.HTTP_1_0) ? VIA_STYX_1_0 : VIA_STYX_1_1;
    }
}

