/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.proxy.plugin;

import com.codahale.metrics.Meter;
import com.hotels.styx.api.Environment;
import com.hotels.styx.api.Eventual;
import com.hotels.styx.api.HttpHandler;
import com.hotels.styx.api.HttpInterceptor;
import com.hotels.styx.api.HttpResponseStatus;
import com.hotels.styx.api.LiveHttpRequest;
import com.hotels.styx.api.LiveHttpResponse;
import com.hotels.styx.api.plugins.spi.Plugin;
import com.hotels.styx.api.plugins.spi.PluginException;
import com.hotels.styx.common.SimpleCache;
import com.hotels.styx.proxy.plugin.NamedPlugin;
import java.util.Map;
import java.util.Objects;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

public class InstrumentedPlugin
implements Plugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstrumentedPlugin.class);
    private final NamedPlugin plugin;
    private final SimpleCache<HttpResponseStatus, Meter> errorStatusMetrics;
    private final SimpleCache<Class<? extends Throwable>, Meter> exceptionMetrics;
    private final Meter errors;

    public InstrumentedPlugin(NamedPlugin plugin, Environment environment) {
        this.plugin = Objects.requireNonNull(plugin);
        Objects.requireNonNull(environment);
        this.errorStatusMetrics = new SimpleCache(statusCode -> environment.metricRegistry().meter("plugins." + plugin.name() + ".response.status." + statusCode.code()));
        this.exceptionMetrics = new SimpleCache(type -> environment.metricRegistry().meter("plugins." + plugin.name() + ".exception." + InstrumentedPlugin.formattedExceptionName(type)));
        this.errors = environment.metricRegistry().meter("plugins." + plugin.name() + ".errors");
        LOGGER.info("Plugin {} instrumented", (Object)plugin.name());
    }

    static String formattedExceptionName(Class<? extends Throwable> type) {
        return type.getName().replace('.', '_');
    }

    public void styxStarting() {
        this.plugin.styxStarting();
    }

    public void styxStopping() {
        this.plugin.styxStopping();
    }

    public Map<String, HttpHandler> adminInterfaceHandlers() {
        return this.plugin.adminInterfaceHandlers();
    }

    public Eventual<LiveHttpResponse> intercept(LiveHttpRequest request, HttpInterceptor.Chain originalChain) {
        StatusRecordingChain chain = new StatusRecordingChain(originalChain);
        try {
            return new Eventual((Publisher)Flux.from(this.plugin.intercept(request, chain)).doOnNext(response -> this.recordStatusCode(chain, (LiveHttpResponse)response)).onErrorResume(error -> Flux.error((Throwable)this.recordAndWrapError(chain, (Throwable)error))));
        }
        catch (Throwable e) {
            this.recordException(e);
            return Eventual.error((Throwable)new PluginException(e, this.plugin.name()));
        }
    }

    private void recordException(Throwable e) {
        ((Meter)this.exceptionMetrics.get(e.getClass())).mark();
        ((Meter)this.errorStatusMetrics.get((Object)HttpResponseStatus.INTERNAL_SERVER_ERROR)).mark();
        this.errors.mark();
    }

    private Throwable recordAndWrapError(StatusRecordingChain chain, Throwable error) {
        if (chain.upstreamException) {
            return error;
        }
        this.recordException(error);
        return new PluginException(error, this.plugin.name());
    }

    private void recordStatusCode(StatusRecordingChain chain, LiveHttpResponse response) {
        boolean fromPlugin;
        boolean isError = response.status().code() >= HttpResponseStatus.BAD_REQUEST.code();
        boolean bl = fromPlugin = response.status() != chain.upstreamStatus;
        if (isError && fromPlugin) {
            ((Meter)this.errorStatusMetrics.get((Object)response.status())).mark();
            if (response.status().equals(HttpResponseStatus.INTERNAL_SERVER_ERROR)) {
                this.errors.mark();
            }
        }
    }

    private static class StatusRecordingChain
    implements HttpInterceptor.Chain {
        private final HttpInterceptor.Chain chain;
        private volatile HttpResponseStatus upstreamStatus;
        private volatile boolean upstreamException;

        StatusRecordingChain(HttpInterceptor.Chain chain) {
            this.chain = chain;
        }

        public HttpInterceptor.Context context() {
            return this.chain.context();
        }

        public Eventual<LiveHttpResponse> proceed(LiveHttpRequest request) {
            try {
                return new Eventual((Publisher)Flux.from((Publisher)this.chain.proceed(request)).doOnNext(response -> {
                    this.upstreamStatus = response.status();
                }).doOnError(error -> {
                    this.upstreamException = true;
                }));
            }
            catch (Error | RuntimeException e) {
                this.upstreamException = true;
                throw e;
            }
            catch (Exception e) {
                this.upstreamException = true;
                throw new RuntimeException(e);
            }
        }
    }
}

