/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.proxy.plugin;

import com.google.common.annotations.VisibleForTesting;
import com.hotels.styx.api.Eventual;
import com.hotels.styx.api.HttpHandler;
import com.hotels.styx.api.HttpInterceptor;
import com.hotels.styx.api.LiveHttpRequest;
import com.hotels.styx.api.LiveHttpResponse;
import com.hotels.styx.api.plugins.spi.Plugin;
import com.hotels.styx.common.Preconditions;
import java.util.Map;
import java.util.Objects;

public final class NamedPlugin
implements Plugin {
    private final String name;
    private final Plugin plugin;
    private volatile boolean enabled = true;

    private NamedPlugin(String name, Plugin plugin) {
        Preconditions.checkArgument((!(plugin instanceof NamedPlugin) ? 1 : 0) != 0, (String)"Cannot wrap %s in %s", (Object[])new Object[]{NamedPlugin.class.getName(), NamedPlugin.class.getName()});
        this.name = Objects.requireNonNull(name);
        this.plugin = Objects.requireNonNull(plugin);
    }

    public static NamedPlugin namedPlugin(String name, Plugin plugin) {
        return new NamedPlugin(name, plugin);
    }

    @VisibleForTesting
    public Plugin originalPlugin() {
        return this.plugin;
    }

    public String name() {
        return this.name;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public void styxStarting() {
        this.plugin.styxStarting();
    }

    public void styxStopping() {
        this.plugin.styxStopping();
    }

    public Map<String, HttpHandler> adminInterfaceHandlers() {
        return this.plugin.adminInterfaceHandlers();
    }

    public Eventual<LiveHttpResponse> intercept(LiveHttpRequest request, HttpInterceptor.Chain chain) {
        if (this.enabled) {
            return this.plugin.intercept(request, chain);
        }
        return chain.proceed(request);
    }
}

