/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.proxy.plugin;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.hotels.styx.common.Pair;
import com.hotels.styx.common.Preconditions;
import com.hotels.styx.common.Strings;
import com.hotels.styx.spi.config.SpiExtension;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class PluginsMetadata
implements Iterable<SpiExtension> {
    private final List<String> activePluginsNames;
    private final List<String> allPluginNames;
    private final Map<String, SpiExtension> plugins;

    PluginsMetadata(@JsonProperty(value="active") String active, @JsonProperty(value="all") Map<String, SpiExtension> plugins) {
        Objects.requireNonNull(plugins, "No list of all plugins specified");
        this.activePluginsNames = Arrays.stream((active == null ? "" : active).split(",")).map(String::trim).filter(Strings::isNotEmpty).collect(Collectors.toList());
        this.allPluginNames = ImmutableList.copyOf(plugins.keySet());
        this.plugins = plugins;
        plugins.forEach((? super K name, ? super V metadata) -> {
            Objects.requireNonNull(metadata.factory(), "Factory missing for plugin '" + name + "'");
            Objects.requireNonNull(metadata.config(), "Config missing for plugin '" + name + "'");
        });
        this.activePluginsNames.forEach(name -> Preconditions.checkArgument((boolean)plugins.containsKey(name), (String)"No such plugin '%s' in %s", (Object[])new Object[]{name, plugins}));
    }

    public List<Pair<String, SpiExtension>> plugins() {
        return this.allPluginNames.stream().map(name -> Pair.pair((Object)name, (Object)this.plugins.get(name))).collect(Collectors.toList());
    }

    public List<Pair<String, SpiExtension>> activePlugins() {
        return this.activePluginsNames.stream().map(name -> Pair.pair((Object)name, (Object)this.plugins.get(name))).collect(Collectors.toList());
    }

    public String toString() {
        return "PluginsMetadata{active=" + this.activePluginsNames + ", plugins=" + this.plugins + '}';
    }

    @Override
    public Iterator<SpiExtension> iterator() {
        return this.plugins.values().iterator();
    }
}

