/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.routing;

import com.hotels.styx.api.Eventual;
import com.hotels.styx.api.HttpInterceptor;
import com.hotels.styx.api.LiveHttpRequest;
import com.hotels.styx.api.LiveHttpResponse;
import com.hotels.styx.api.ResponseEventListener;
import com.hotels.styx.api.extension.loadbalancing.spi.LoadBalancingMetric;
import com.hotels.styx.routing.RoutingObject;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.LongAdder;
import org.reactivestreams.Publisher;

public class RoutingMetadataDecorator
implements RoutingObject {
    private final RoutingObject delegate;
    private final LongAdder allRequests = new LongAdder();
    private final LongAdder finishedRequests = new LongAdder();

    public RoutingMetadataDecorator(RoutingObject routingObject) {
        this.delegate = Objects.requireNonNull(routingObject);
    }

    public Eventual<LiveHttpResponse> handle(LiveHttpRequest request, HttpInterceptor.Context context) {
        this.allRequests.increment();
        return new Eventual((Publisher)ResponseEventListener.from((Publisher)this.delegate.handle(request, context)).whenFinished(this.finishedRequests::increment).apply());
    }

    @Override
    public CompletableFuture<Void> stop() {
        return this.delegate.stop();
    }

    public LoadBalancingMetric metric() {
        return new LoadBalancingMetric(this.allRequests.intValue() - this.finishedRequests.intValue());
    }
}

