/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.routing;

import com.google.common.annotations.VisibleForTesting;
import com.hotels.styx.Environment;
import com.hotels.styx.NettyExecutor;
import com.hotels.styx.api.extension.service.BackendService;
import com.hotels.styx.api.extension.service.spi.Registry;
import com.hotels.styx.proxy.BackendServiceClientFactory;
import com.hotels.styx.proxy.BackendServicesRouter;
import com.hotels.styx.proxy.InterceptorPipelineBuilder;
import com.hotels.styx.proxy.RouteHandlerAdapter;
import com.hotels.styx.proxy.StyxBackendServiceClientFactory;
import com.hotels.styx.proxy.plugin.NamedPlugin;
import com.hotels.styx.routing.RoutingObject;
import java.util.Objects;

public class StaticPipelineFactory {
    private final BackendServiceClientFactory clientFactory;
    private final Environment environment;
    private final Registry<BackendService> registry;
    private final Iterable<NamedPlugin> plugins;
    private final NettyExecutor executor;
    private final boolean trackRequests;

    @VisibleForTesting
    StaticPipelineFactory(BackendServiceClientFactory clientFactory, Environment environment, Registry<BackendService> registry, Iterable<NamedPlugin> plugins, NettyExecutor executor, boolean trackRequests) {
        this.clientFactory = Objects.requireNonNull(clientFactory);
        this.environment = Objects.requireNonNull(environment);
        this.registry = Objects.requireNonNull(registry);
        this.plugins = Objects.requireNonNull(plugins);
        this.executor = Objects.requireNonNull(executor);
        this.trackRequests = trackRequests;
    }

    public StaticPipelineFactory(Environment environment, Registry<BackendService> registry, Iterable<NamedPlugin> plugins, NettyExecutor executor, boolean trackRequests) {
        this(StaticPipelineFactory.createClientFactory(environment), environment, registry, plugins, executor, trackRequests);
    }

    private static BackendServiceClientFactory createClientFactory(Environment environment) {
        return new StyxBackendServiceClientFactory(environment);
    }

    public RoutingObject build() {
        BackendServicesRouter backendServicesRouter = new BackendServicesRouter(this.clientFactory, this.environment, this.executor);
        this.registry.addListener((Registry.ChangeListener)backendServicesRouter);
        RouteHandlerAdapter router2 = new RouteHandlerAdapter(backendServicesRouter);
        return new InterceptorPipelineBuilder(this.environment, this.plugins, router2, this.trackRequests).build();
    }
}

