/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.routing.config;

import com.google.common.collect.ImmutableMap;
import com.hotels.styx.ExecutorFactory;
import com.hotels.styx.InetServer;
import com.hotels.styx.NettyExecutor;
import com.hotels.styx.StyxObjectRecord;
import com.hotels.styx.api.Eventual;
import com.hotels.styx.api.HttpInterceptor;
import com.hotels.styx.api.HttpResponse;
import com.hotels.styx.api.HttpResponseStatus;
import com.hotels.styx.api.extension.service.spi.StyxService;
import com.hotels.styx.common.Preconditions;
import com.hotels.styx.config.schema.Schema;
import com.hotels.styx.executors.NettyExecutorFactory;
import com.hotels.styx.routing.RoutingObject;
import com.hotels.styx.routing.config.HttpInterceptorFactory;
import com.hotels.styx.routing.config.RoutingObjectFactory;
import com.hotels.styx.routing.config.StyxObjectConfiguration;
import com.hotels.styx.routing.config.StyxObjectDefinition;
import com.hotels.styx.routing.config.StyxObjectReference;
import com.hotels.styx.routing.db.StyxObjectStore;
import com.hotels.styx.routing.handlers.ConditionRouter;
import com.hotels.styx.routing.handlers.HostProxy;
import com.hotels.styx.routing.handlers.HttpInterceptorPipeline;
import com.hotels.styx.routing.handlers.LoadBalancingGroup;
import com.hotels.styx.routing.handlers.PathPrefixRouter;
import com.hotels.styx.routing.handlers.ProxyToBackend;
import com.hotels.styx.routing.handlers.RouteRefLookup;
import com.hotels.styx.routing.handlers.StaticResponseHandler;
import com.hotels.styx.routing.interceptors.RewriteInterceptor;
import com.hotels.styx.servers.StyxHttpServer;
import com.hotels.styx.servers.StyxHttpServerFactory;
import com.hotels.styx.serviceproviders.ServiceProviderFactory;
import com.hotels.styx.serviceproviders.StyxServerFactory;
import com.hotels.styx.services.HealthCheckMonitoringService;
import com.hotels.styx.services.HealthCheckMonitoringServiceFactory;
import com.hotels.styx.services.YamlFileConfigurationService;
import com.hotels.styx.services.YamlFileConfigurationServiceFactory;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;

public final class Builtins {
    public static final String STATIC_RESPONSE = "StaticResponseHandler";
    public static final String CONDITION_ROUTER = "ConditionRouter";
    public static final String INTERCEPTOR_PIPELINE = "InterceptorPipeline";
    public static final String PROXY_TO_BACKEND = "ProxyToBackend";
    public static final String PATH_PREFIX_ROUTER = "PathPrefixRouter";
    public static final String HOST_PROXY = "HostProxy";
    public static final String LOAD_BALANCING_GROUP = "LoadBalancingGroup";
    public static final String HEALTH_CHECK_MONITOR = "HealthCheckMonitor";
    public static final String YAML_FILE_CONFIGURATION_SERVICE = "YamlFileConfigurationService";
    public static final String REWRITE = "Rewrite";
    public static final ImmutableMap<String, Schema.FieldType> BUILTIN_HANDLER_SCHEMAS;
    public static final ImmutableMap<String, RoutingObjectFactory> BUILTIN_HANDLER_FACTORIES;
    public static final ImmutableMap<String, HttpInterceptorFactory> INTERCEPTOR_FACTORIES;
    public static final ImmutableMap<String, Schema.FieldType> INTERCEPTOR_SCHEMAS;
    public static final ImmutableMap<String, ServiceProviderFactory> BUILTIN_SERVICE_PROVIDER_FACTORIES;
    public static final ImmutableMap<String, Schema.FieldType> BUILTIN_SERVICE_PROVIDER_SCHEMAS;
    public static final ImmutableMap<String, StyxServerFactory> BUILTIN_SERVER_FACTORIES;
    public static final ImmutableMap<String, Schema.FieldType> BUILTIN_SERVER_SCHEMAS;
    public static final ImmutableMap<String, ExecutorFactory> BUILTIN_EXECUTOR_FACTORIES;
    public static final ImmutableMap<String, Schema.FieldType> BUILTIN_EXECUTOR_SCHEMAS;
    public static final RouteRefLookup DEFAULT_REFERENCE_LOOKUP;

    private Builtins() {
    }

    public static RoutingObject build(List<String> parents, RoutingObjectFactory.Context context, StyxObjectConfiguration configNode) {
        if (configNode instanceof StyxObjectDefinition) {
            StyxObjectDefinition configBlock = (StyxObjectDefinition)configNode;
            String type = configBlock.type();
            RoutingObjectFactory factory = context.objectFactories().get(type);
            Preconditions.checkArgument((factory != null ? 1 : 0) != 0, (Object)String.format("Unknown handler type '%s'", type));
            return factory.build(parents, context, configBlock);
        }
        if (configNode instanceof StyxObjectReference) {
            return (request, httpContext) -> context.refLookup().apply((StyxObjectReference)configNode).handle(request, httpContext);
        }
        throw new UnsupportedOperationException(String.format("Unsupported configuration node type: '%s'", configNode.getClass().getName()));
    }

    public static HttpInterceptor build(StyxObjectConfiguration configBlock, Map<String, HttpInterceptorFactory> interceptorFactories) {
        if (configBlock instanceof StyxObjectDefinition) {
            StyxObjectDefinition block = (StyxObjectDefinition)configBlock;
            String type = block.type();
            HttpInterceptorFactory constructor = interceptorFactories.get(type);
            Preconditions.checkArgument((constructor != null ? 1 : 0) != 0, (Object)String.format("Unknown service provider type '%s'", type));
            return constructor.build(block);
        }
        throw new UnsupportedOperationException("Routing config node must be an config block, not a reference");
    }

    public static StyxService build(String name, StyxObjectDefinition providerDef, StyxObjectStore<StyxObjectRecord<StyxService>> serviceDb, Map<String, ServiceProviderFactory> factories, RoutingObjectFactory.Context context) {
        ServiceProviderFactory constructor = factories.get(providerDef.type());
        Preconditions.checkArgument((constructor != null ? 1 : 0) != 0, (Object)String.format("Unknown service provider type '%s' for '%s' provider", providerDef.type(), providerDef.name()));
        return constructor.create(name, context, providerDef.config(), serviceDb);
    }

    public static InetServer buildServer(String name, StyxObjectDefinition serverDef, StyxObjectStore<StyxObjectRecord<InetServer>> serverDb, Map<String, StyxServerFactory> factories, RoutingObjectFactory.Context context) {
        StyxServerFactory constructor = factories.get(serverDef.type());
        Preconditions.checkArgument((constructor != null ? 1 : 0) != 0, (Object)String.format("Unknown server type '%s' for '%s' provider", serverDef.type(), serverDef.name()));
        return constructor.create(name, context, serverDef.config(), serverDb);
    }

    public static NettyExecutor buildExecutor(String name, StyxObjectDefinition serverDef, Map<String, ExecutorFactory> factories) {
        ExecutorFactory constructor = factories.get(serverDef.type());
        Preconditions.checkArgument((constructor != null ? 1 : 0) != 0, (Object)String.format("Unknown executor type '%s' for '%s' provider", serverDef.type(), serverDef.name()));
        return constructor.create(name, serverDef.config());
    }

    static {
        INTERCEPTOR_FACTORIES = ImmutableMap.of((Object)REWRITE, (Object)new RewriteInterceptor.Factory());
        INTERCEPTOR_SCHEMAS = ImmutableMap.of((Object)REWRITE, (Object)RewriteInterceptor.SCHEMA);
        BUILTIN_SERVICE_PROVIDER_FACTORIES = ImmutableMap.of((Object)HEALTH_CHECK_MONITOR, (Object)new HealthCheckMonitoringServiceFactory(), (Object)YAML_FILE_CONFIGURATION_SERVICE, (Object)new YamlFileConfigurationServiceFactory());
        BUILTIN_SERVICE_PROVIDER_SCHEMAS = ImmutableMap.of((Object)HEALTH_CHECK_MONITOR, (Object)HealthCheckMonitoringService.SCHEMA, (Object)YAML_FILE_CONFIGURATION_SERVICE, (Object)YamlFileConfigurationService.SCHEMA);
        BUILTIN_SERVER_FACTORIES = ImmutableMap.of((Object)"HttpServer", (Object)new StyxHttpServerFactory());
        BUILTIN_SERVER_SCHEMAS = ImmutableMap.of((Object)"HttpServer", (Object)StyxHttpServer.SCHEMA);
        BUILTIN_EXECUTOR_FACTORIES = ImmutableMap.of((Object)"NettyExecutor", (Object)new NettyExecutorFactory());
        BUILTIN_EXECUTOR_SCHEMAS = ImmutableMap.of((Object)"NettyExecutor", (Object)NettyExecutorFactory.SCHEMA);
        DEFAULT_REFERENCE_LOOKUP = reference -> (request, ctx) -> Eventual.of((Object)HttpResponse.response((HttpResponseStatus)HttpResponseStatus.NOT_FOUND).body(String.format("Handler not found for '%s'.", reference), StandardCharsets.UTF_8).build().stream());
        BUILTIN_HANDLER_FACTORIES = ImmutableMap.builder().put((Object)STATIC_RESPONSE, (Object)new StaticResponseHandler.Factory()).put((Object)CONDITION_ROUTER, (Object)new ConditionRouter.Factory()).put((Object)INTERCEPTOR_PIPELINE, (Object)new HttpInterceptorPipeline.Factory()).put((Object)PROXY_TO_BACKEND, (Object)new ProxyToBackend.Factory()).put((Object)PATH_PREFIX_ROUTER, (Object)new PathPrefixRouter.Factory()).put((Object)HOST_PROXY, (Object)new HostProxy.Factory()).put((Object)LOAD_BALANCING_GROUP, (Object)new LoadBalancingGroup.Factory()).build();
        BUILTIN_HANDLER_SCHEMAS = ImmutableMap.builder().put((Object)STATIC_RESPONSE, (Object)StaticResponseHandler.SCHEMA).put((Object)CONDITION_ROUTER, (Object)ConditionRouter.SCHEMA).put((Object)INTERCEPTOR_PIPELINE, (Object)HttpInterceptorPipeline.SCHEMA).put((Object)PROXY_TO_BACKEND, (Object)ProxyToBackend.SCHEMA).put((Object)PATH_PREFIX_ROUTER, (Object)PathPrefixRouter.SCHEMA).put((Object)HOST_PROXY, (Object)HostProxy.SCHEMA).put((Object)LOAD_BALANCING_GROUP, (Object)LoadBalancingGroup.Companion.getSCHEMA()).build();
    }
}

