/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.routing.config;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.hotels.styx.routing.config.StyxObjectConfiguration;
import com.hotels.styx.routing.config.StyxObjectDefinition;
import com.hotels.styx.routing.config.StyxObjectReference;
import java.util.Objects;
import java.util.Optional;

public final class RoutingConfigParser {
    private RoutingConfigParser() {
    }

    public static StyxObjectConfiguration toRoutingConfigNode(JsonNode jsonNode) {
        if (jsonNode.getNodeType() == JsonNodeType.STRING) {
            return new StyxObjectReference(jsonNode.asText());
        }
        if (jsonNode.getNodeType() == JsonNodeType.OBJECT) {
            String name = RoutingConfigParser.getOrElse(jsonNode, "name", "");
            String type = RoutingConfigParser.getMandatory(jsonNode, "type", String.format("Routing config definition must have a 'type' attribute in def='%s'", name));
            JsonNode conf = jsonNode.get("config");
            return new StyxObjectDefinition(name, type, conf);
        }
        throw new IllegalArgumentException("invalid configuration");
    }

    private static String getMandatory(JsonNode jsonNode, String attributeName, String message) {
        if (!jsonNode.has(attributeName)) {
            throw new IllegalArgumentException(message);
        }
        return Objects.requireNonNull(jsonNode.get(attributeName).asText());
    }

    private static String getOrElse(JsonNode jsonNode, String attributeName, String defaultValue) {
        return Optional.ofNullable(jsonNode.get(attributeName)).map(JsonNode::asText).orElse(defaultValue);
    }
}

