/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.routing.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.collect.ImmutableList;
import com.hotels.styx.infrastructure.configuration.yaml.JsonNodeConfig;
import com.hotels.styx.routing.config.StyxObjectConfiguration;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public class StyxObjectDefinition
implements StyxObjectConfiguration {
    private final String name;
    private final String type;
    private final List<String> tags;
    private final JsonNode config;

    public StyxObjectDefinition(String name, String type, List<String> tags, JsonNode config) {
        this.name = Objects.requireNonNull(name);
        this.type = Objects.requireNonNull(type);
        this.tags = ImmutableList.copyOf(tags);
        this.config = Objects.requireNonNull(config);
    }

    public StyxObjectDefinition(String name, String type, JsonNode config) {
        this(name, type, (List<String>)ImmutableList.of(), config);
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public List<String> tags() {
        return this.tags;
    }

    public JsonNode config() {
        return this.config;
    }

    public <T> T config(Class<T> tClass) {
        return new JsonNodeConfig(this.config).as(tClass);
    }

    static class Builder {
        private List<String> tags = ImmutableList.of();
        private String name = "";
        private JsonNode config;
        private String type;

        Builder() {
        }

        @JsonProperty(value="name")
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="type")
        public Builder type(String type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="tags")
        public Builder tags(List<String> tags) {
            this.tags = tags;
            return this;
        }

        @JsonProperty(value="config")
        public Builder config(JsonNode config) {
            this.config = config;
            return this;
        }

        public StyxObjectDefinition build() {
            return new StyxObjectDefinition(this.name, this.type, this.tags, this.config);
        }
    }
}

