/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.routing.db;

import com.hotels.styx.api.configuration.ObjectStore;
import com.hotels.styx.routing.db.DispatchListenerNotification;
import com.hotels.styx.routing.db.IndexedSnapshot;
import com.hotels.styx.routing.db.NotificationQueue;
import com.hotels.styx.routing.db.NotificationQueueKt;
import com.hotels.styx.routing.db.StyxObjectStore;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.pcollections.HashPMap;
import org.pcollections.HashTreePMap;
import org.pcollections.PMap;
import org.reactivestreams.Publisher;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010&\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 -*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001-B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\u000f\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J9\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\"\u0010\u0014\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0015\u0012\u0004\u0012\u00020\u000f0\u000ej\b\u0012\u0004\u0012\u00028\u0000`\u0016H\u0000\u00a2\u0006\u0002\b\u0017J,\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00192\u0006\u0010\u0012\u001a\u00020\u00132\u0016\u0010\u001a\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u000eJ\u001a\u0010\u001b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00028\u00000\u001d0\u001cH\u0016J\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00192\u0006\u0010\u001f\u001a\u00020\u0013H\u0096\u0002J\b\u0010 \u001a\u00020!H\u0016J!\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000\u00192\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010#\u001a\u00028\u0000\u00a2\u0006\u0002\u0010$J\u001c\u0010\t\u001a\u0016\u0012\u0004\u0012\u00028\u0000 %*\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000b0\u000bH\u0002J\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000\u00192\u0006\u0010\u0012\u001a\u00020\u0013J\u0015\u0010'\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b(J\u0012\u0010)\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00020*J\r\u0010\f\u001a\u00020+H\u0000\u00a2\u0006\u0002\b,R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\f\u001a$\u0012 \u0012\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0002\u0012\u0004\u0012\u00020\u000f0\u000ej\b\u0012\u0004\u0012\u00028\u0000`\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/hotels/styx/routing/db/StyxObjectStore;", "T", "Lcom/hotels/styx/api/configuration/ObjectStore;", "()V", "executor", "Ljava/util/concurrent/ExecutorService;", "(Ljava/util/concurrent/ExecutorService;)V", "notificationQueue", "Lcom/hotels/styx/routing/db/NotificationQueue;", "objects", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/hotels/styx/routing/db/IndexedSnapshot;", "watchers", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lkotlin/Function1;", "", "Lcom/hotels/styx/routing/db/ChangeWatcher;", "addDispatchListener", "key", "", "listener", "Lcom/hotels/styx/routing/db/DispatchListenerNotification;", "Lcom/hotels/styx/routing/db/DispatchListener;", "addDispatchListener$styx_proxy", "compute", "Ljava/util/Optional;", "computation", "entrySet", "", "", "get", "name", "index", "", "insert", "payload", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/util/Optional;", "kotlin.jvm.PlatformType", "remove", "removeDispatchListener", "removeDispatchListener$styx_proxy", "watch", "Lorg/reactivestreams/Publisher;", "", "watchers$styx_proxy", "Companion", "styx-proxy"})
public final class StyxObjectStore<T>
implements ObjectStore<T> {
    private final AtomicReference<IndexedSnapshot<T>> objects;
    private final CopyOnWriteArrayList<Function1<ObjectStore<T>, Unit>> watchers;
    private final NotificationQueue<T> notificationQueue;
    private static final ExecutorService sharedExecutor;
    public static final Companion Companion;

    @NotNull
    public Optional<T> get(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Optional<Object> optional = Optional.ofNullable(this.objects().getSnapshot().get((Object)name));
        Intrinsics.checkExpressionValueIsNotNull(optional, (String)"Optional.ofNullable(objects().snapshot.get(name))");
        return optional;
    }

    @NotNull
    public Collection<Map.Entry<String, T>> entrySet() {
        return NotificationQueueKt.entrySet(this.objects.get().getSnapshot());
    }

    @NotNull
    public final Optional<T> insert(@NotNull String key, T payload) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        CharSequence charSequence = key;
        boolean bl = false;
        boolean bl2 = charSequence.length() > 0;
        bl = false;
        boolean bl3 = false;
        if (!bl2) {
            boolean bl4 = false;
            String string = "ObjectStore insert: empty keys are not allowed.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        IndexedSnapshot<T> current = this.objects.get();
        IndexedSnapshot<T> indexedSnapshot = current.map((Function1)new Function1<PMap<String, T>, PMap<String, T>>(key, payload){
            final /* synthetic */ String $key;
            final /* synthetic */ Object $payload;

            public final PMap<String, T> invoke(@NotNull PMap<String, T> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                PMap pMap = it.plus((Object)this.$key, this.$payload);
                Intrinsics.checkExpressionValueIsNotNull((Object)pMap, (String)"it.plus(key, payload)");
                return pMap;
            }
            {
                this.$key = string;
                this.$payload = object;
                super(1);
            }
        });
        while (!this.objects.compareAndSet(current, indexedSnapshot)) {
            current = this.objects.get();
            indexedSnapshot = current.map((Function1)new Function1<PMap<String, T>, PMap<String, T>>(key, payload){
                final /* synthetic */ String $key;
                final /* synthetic */ Object $payload;

                public final PMap<String, T> invoke(@NotNull PMap<String, T> it) {
                    Intrinsics.checkParameterIsNotNull(it, (String)"it");
                    PMap pMap = it.plus((Object)this.$key, this.$payload);
                    Intrinsics.checkExpressionValueIsNotNull((Object)pMap, (String)"it.plus(key, payload)");
                    return pMap;
                }
                {
                    this.$key = string;
                    this.$payload = object;
                    super(1);
                }
            });
        }
        this.notificationQueue.publishChange(indexedSnapshot);
        Optional<Object> optional = Optional.ofNullable(current.getSnapshot().get((Object)key));
        Intrinsics.checkExpressionValueIsNotNull(optional, (String)"Optional.ofNullable(current.snapshot[key])");
        return optional;
    }

    @NotNull
    public final Optional<T> compute(@NotNull String key, @NotNull Function1<? super T, ? extends T> computation) {
        Object existingValue;
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull(computation, (String)"computation");
        CharSequence charSequence = key;
        boolean bl = false;
        boolean bl2 = charSequence.length() > 0;
        bl = false;
        boolean bl3 = false;
        if (!bl2) {
            boolean bl4 = false;
            String string = "ObjectStore compute: empty keys are not allowed.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        IndexedSnapshot<T> current = null;
        Ref.ObjectRef result2 = new Ref.ObjectRef();
        IndexedSnapshot<T> indexedSnapshot = null;
        do {
            Intrinsics.checkExpressionValueIsNotNull(this.objects.get(), (String)"objects.get()");
            existingValue = current.getSnapshot().get((Object)key);
            result2.element = computation.invoke(existingValue);
        } while (!this.objects.compareAndSet(current, indexedSnapshot = existingValue != null && result2.element == null ? current.map((Function1)new Function1<PMap<String, T>, PMap<String, T>>(key){
            final /* synthetic */ String $key;

            public final PMap<String, T> invoke(@NotNull PMap<String, T> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                PMap pMap = it.minus((Object)this.$key);
                Intrinsics.checkExpressionValueIsNotNull((Object)pMap, (String)"it.minus(key)");
                return pMap;
            }
            {
                this.$key = string;
                super(1);
            }
        }) : (Intrinsics.areEqual((Object)result2.element, (Object)existingValue) ^ true ? current.map((Function1)new Function1<PMap<String, T>, PMap<String, T>>(key, result2){
            final /* synthetic */ String $key;
            final /* synthetic */ Ref.ObjectRef $result;

            public final PMap<String, T> invoke(@NotNull PMap<String, T> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                PMap pMap = it.plus((Object)this.$key, this.$result.element);
                Intrinsics.checkExpressionValueIsNotNull((Object)pMap, (String)"it.plus(key, result)");
                return pMap;
            }
            {
                this.$key = string;
                this.$result = objectRef;
                super(1);
            }
        }) : current)));
        if (Intrinsics.areEqual(current, indexedSnapshot) ^ true) {
            this.notificationQueue.publishChange(indexedSnapshot);
        }
        Optional<Object> optional = Optional.ofNullable(current.getSnapshot().get((Object)key));
        Intrinsics.checkExpressionValueIsNotNull(optional, (String)"Optional.ofNullable(current.snapshot[key])");
        return optional;
    }

    @NotNull
    public final Optional<T> remove(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        IndexedSnapshot<T> current = this.objects.get();
        IndexedSnapshot<T> indexedSnapshot = current.map((Function1)new Function1<PMap<String, T>, PMap<String, T>>(key){
            final /* synthetic */ String $key;

            public final PMap<String, T> invoke(@NotNull PMap<String, T> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                PMap pMap = it.minus((Object)this.$key);
                Intrinsics.checkExpressionValueIsNotNull((Object)pMap, (String)"it.minus(key)");
                return pMap;
            }
            {
                this.$key = string;
                super(1);
            }
        });
        while (!this.objects.compareAndSet(current, indexedSnapshot)) {
            current = this.objects.get();
            indexedSnapshot = current.map((Function1)new Function1<PMap<String, T>, PMap<String, T>>(key){
                final /* synthetic */ String $key;

                public final PMap<String, T> invoke(@NotNull PMap<String, T> it) {
                    Intrinsics.checkParameterIsNotNull(it, (String)"it");
                    PMap pMap = it.minus((Object)this.$key);
                    Intrinsics.checkExpressionValueIsNotNull((Object)pMap, (String)"it.minus(key)");
                    return pMap;
                }
                {
                    this.$key = string;
                    super(1);
                }
            });
        }
        if (Intrinsics.areEqual(current.getSnapshot(), indexedSnapshot.getSnapshot()) ^ true) {
            this.notificationQueue.publishChange(indexedSnapshot);
        }
        Optional<Object> optional = Optional.ofNullable(current.getSnapshot().get((Object)key));
        Intrinsics.checkExpressionValueIsNotNull(optional, (String)"Optional.ofNullable(current.snapshot[key])");
        return optional;
    }

    @NotNull
    public final Publisher<ObjectStore<T>> watch() {
        Flux flux = Flux.push((Consumer)new Consumer<FluxSink<T>>(this){
            final /* synthetic */ StyxObjectStore this$0;

            public final void accept(FluxSink<ObjectStore<T>> sink) {
                Function1 watcher2 = (Function1)new Function1<ObjectStore<T>, Unit>(sink){
                    final /* synthetic */ FluxSink $sink;

                    public final void invoke(@NotNull ObjectStore<T> it) {
                        Intrinsics.checkParameterIsNotNull(it, (String)"it");
                        this.$sink.next(it);
                    }
                    {
                        this.$sink = fluxSink;
                        super(1);
                    }
                };
                sink.onDispose(new Disposable(this, watcher2){
                    final /* synthetic */ watch.1 this$0;
                    final /* synthetic */ Function1 $watcher;

                    public final void dispose() {
                        StyxObjectStore.access$getWatchers$p(this.this$0.this$0).remove(this.$watcher);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$watcher = function1;
                    }
                });
                StyxObjectStore.access$getWatchers$p(this.this$0).add(watcher2);
                NotificationQueue notificationQueue = StyxObjectStore.access$getNotificationQueue$p(this.this$0);
                FluxSink<ObjectStore<T>> fluxSink = sink;
                Intrinsics.checkExpressionValueIsNotNull(fluxSink, (String)"sink");
                notificationQueue.publishInitialWatch(fluxSink);
            }
            {
                this.this$0 = styxObjectStore;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)flux, (String)"Flux.push { sink ->\n    \u2026tialWatch(sink)\n        }");
        return (Publisher)flux;
    }

    public final int watchers$styx_proxy() {
        return this.watchers.size();
    }

    private final IndexedSnapshot<T> objects() {
        return this.objects.get();
    }

    public long index() {
        return this.objects.get().getIndex();
    }

    public final void addDispatchListener$styx_proxy(@NotNull String key, @NotNull Function1<? super DispatchListenerNotification<T>, Unit> listener) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull(listener, (String)"listener");
        this.notificationQueue.addDispatchListener$styx_proxy(key, listener);
    }

    public final void removeDispatchListener$styx_proxy(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.notificationQueue.removeDispatchListener$styx_proxy(key);
    }

    public StyxObjectStore(@NotNull ExecutorService executor) {
        Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
        HashPMap hashPMap = HashTreePMap.empty();
        Intrinsics.checkExpressionValueIsNotNull((Object)hashPMap, (String)"HashTreePMap.empty()");
        this.objects = new AtomicReference(new IndexedSnapshot(0L, (PMap)hashPMap));
        this.watchers = new CopyOnWriteArrayList();
        this.notificationQueue = new NotificationQueue<T>(this.watchers, executor);
    }

    public StyxObjectStore() {
        ExecutorService executorService = sharedExecutor;
        Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"sharedExecutor");
        this(executorService);
    }

    static {
        Companion = new Companion(null);
        sharedExecutor = Executors.newSingleThreadExecutor();
    }

    public static final /* synthetic */ CopyOnWriteArrayList access$getWatchers$p(StyxObjectStore $this) {
        return $this.watchers;
    }

    public static final /* synthetic */ NotificationQueue access$getNotificationQueue$p(StyxObjectStore $this) {
        return $this.notificationQueue;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/hotels/styx/routing/db/StyxObjectStore$Companion;", "", "()V", "sharedExecutor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "styx-proxy"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

