/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.routing.handlers;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.hotels.styx.api.Eventual;
import com.hotels.styx.api.HttpHandler;
import com.hotels.styx.api.HttpInterceptor;
import com.hotels.styx.api.HttpResponseStatus;
import com.hotels.styx.api.LiveHttpRequest;
import com.hotels.styx.api.LiveHttpResponse;
import com.hotels.styx.config.schema.Schema;
import com.hotels.styx.config.schema.SchemaDirective;
import com.hotels.styx.config.schema.SchemaDsl;
import com.hotels.styx.infrastructure.configuration.yaml.JsonNodeConfig;
import com.hotels.styx.proxy.RouteHandlerAdapter;
import com.hotels.styx.routing.RoutingObject;
import com.hotels.styx.routing.config.Builtins;
import com.hotels.styx.routing.config.RoutingConfigParser;
import com.hotels.styx.routing.config.RoutingObjectFactory;
import com.hotels.styx.routing.config.RoutingSupport;
import com.hotels.styx.routing.config.StyxObjectConfiguration;
import com.hotels.styx.routing.config.StyxObjectDefinition;
import com.hotels.styx.server.HttpRouter;
import com.hotels.styx.server.routing.AntlrMatcher;
import com.hotels.styx.server.routing.antlr.DslFunctionResolutionError;
import com.hotels.styx.server.routing.antlr.DslSyntaxError;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class ConditionRouter
implements HttpRouter {
    public static final Schema.FieldType SCHEMA = SchemaDsl.object((SchemaDirective[])new SchemaDirective[]{SchemaDsl.field((String)"routes", (Schema.FieldType)SchemaDsl.list((Schema.FieldType)SchemaDsl.object((SchemaDirective[])new SchemaDirective[]{SchemaDsl.field((String)"condition", (Schema.FieldType)SchemaDsl.string()), SchemaDsl.field((String)"destination", (Schema.FieldType)SchemaDsl.routingObject())}))), SchemaDsl.optional((String)"fallback", (Schema.FieldType)SchemaDsl.routingObject())});
    private final List<Route> routes;
    private final RoutingObject fallback;

    private ConditionRouter(List<Route> routes, RoutingObject fallback) {
        this.routes = routes;
        this.fallback = fallback;
    }

    public Optional<HttpHandler> route(LiveHttpRequest request, HttpInterceptor.Context context) {
        for (Route route : this.routes) {
            HttpHandler handler = route.match(request, context);
            if (handler == null) continue;
            return Optional.of(handler);
        }
        return Optional.ofNullable(this.fallback);
    }

    private static class Route {
        private final AntlrMatcher matcher;
        private final RoutingObject routingObject;

        Route(String condition, RoutingObject routingObject) {
            this.matcher = AntlrMatcher.antlrMatcher((String)condition);
            this.routingObject = routingObject;
        }

        public HttpHandler match(LiveHttpRequest request, HttpInterceptor.Context context) {
            return this.matcher.apply(request, context) ? this.routingObject : null;
        }
    }

    public static class Factory
    implements RoutingObjectFactory {
        private static RoutingObject buildFallbackHandler(List<String> parents, RoutingObjectFactory.Context context, ConditionRouterConfig config) {
            if (config.fallback == null) {
                return (request, na) -> Eventual.of((Object)LiveHttpResponse.response((HttpResponseStatus)HttpResponseStatus.BAD_GATEWAY).build());
            }
            return Builtins.build(RoutingSupport.append(parents, "fallback"), context, config.fallback);
        }

        private static Route buildRoute(List<String> parents, RoutingObjectFactory.Context context, int index, String condition, StyxObjectConfiguration destination) {
            try {
                String attribute = String.format("destination[%d]", index);
                RoutingObject handler = Builtins.build(RoutingSupport.append(parents, attribute), context, destination);
                return new Route(condition, handler);
            }
            catch (DslFunctionResolutionError | DslSyntaxError e) {
                String attribute = String.format("condition[%d]", index);
                String path = String.join((CharSequence)".", RoutingSupport.append(parents, attribute));
                String msg = String.format("Routing object definition of type 'ConditionRouter', attribute='%s', failed to compile routing expression condition='%s'", path, condition);
                throw new IllegalArgumentException(msg, e);
            }
        }

        @Override
        public RoutingObject build(List<String> fullName, RoutingObjectFactory.Context context, StyxObjectDefinition configBlock) {
            ConditionRouterConfig config = new JsonNodeConfig(configBlock.config()).as(ConditionRouterConfig.class);
            if (config.routes == null) {
                throw RoutingSupport.missingAttributeError(configBlock, String.join((CharSequence)".", fullName), "routes");
            }
            AtomicInteger index = new AtomicInteger(0);
            final List routes = config.routes.stream().map(routeConfig -> Factory.buildRoute(RoutingSupport.append(fullName, "routes"), context, index.getAndIncrement(), ((ConditionRouterRouteConfig)routeConfig).condition, ((ConditionRouterRouteConfig)routeConfig).destination)).collect(Collectors.toList());
            final RoutingObject fallbackHandler = Factory.buildFallbackHandler(fullName, context, config);
            ConditionRouter router2 = new ConditionRouter(routes, fallbackHandler);
            return new RouteHandlerAdapter(router2){

                @Override
                public CompletableFuture<Void> stop() {
                    fallbackHandler.stop();
                    routes.stream().map(route -> ((Route)route).routingObject).forEach(RoutingObject::stop);
                    return CompletableFuture.completedFuture(null);
                }
            };
        }

        private static class ConditionRouterRouteConfig {
            private final String condition;
            private final StyxObjectConfiguration destination;

            public ConditionRouterRouteConfig(@JsonProperty(value="condition") String condition, @JsonProperty(value="destination") JsonNode destination) {
                this.condition = condition;
                this.destination = RoutingConfigParser.toRoutingConfigNode(destination);
            }
        }

        private static class ConditionRouterConfig {
            private final List<ConditionRouterRouteConfig> routes;
            private final StyxObjectConfiguration fallback;

            private ConditionRouterConfig(@JsonProperty(value="routes") List<ConditionRouterRouteConfig> routes, @JsonProperty(value="fallback") JsonNode fallback) {
                this.routes = routes;
                this.fallback = fallback.isNull() ? null : RoutingConfigParser.toRoutingConfigNode(fallback);
            }
        }
    }
}

