/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.routing.handlers;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.net.HostAndPort;
import com.hotels.styx.NettyExecutor;
import com.hotels.styx.StyxObjectRecord;
import com.hotels.styx.api.Eventual;
import com.hotels.styx.api.HttpInterceptor;
import com.hotels.styx.api.Id;
import com.hotels.styx.api.LiveHttpRequest;
import com.hotels.styx.api.LiveHttpResponse;
import com.hotels.styx.api.MetricRegistry;
import com.hotels.styx.api.ResponseEventListener;
import com.hotels.styx.api.extension.Origin;
import com.hotels.styx.api.extension.service.ConnectionPoolSettings;
import com.hotels.styx.api.extension.service.TlsSettings;
import com.hotels.styx.client.Connection;
import com.hotels.styx.client.HttpConfig;
import com.hotels.styx.client.HttpRequestOperationFactory;
import com.hotels.styx.client.OriginStatsFactory;
import com.hotels.styx.client.StyxHostHttpClient;
import com.hotels.styx.client.applications.metrics.OriginMetrics;
import com.hotels.styx.client.connectionpool.ConnectionPool;
import com.hotels.styx.client.connectionpool.ExpiringConnectionFactory;
import com.hotels.styx.client.connectionpool.SimpleConnectionPoolFactory;
import com.hotels.styx.client.netty.connectionpool.NettyConnectionFactory;
import com.hotels.styx.config.schema.Schema;
import com.hotels.styx.config.schema.SchemaDirective;
import com.hotels.styx.config.schema.SchemaDsl;
import com.hotels.styx.infrastructure.configuration.yaml.JsonNodeConfig;
import com.hotels.styx.routing.RoutingObject;
import com.hotels.styx.routing.config.RoutingObjectFactory;
import com.hotels.styx.routing.config.RoutingSupport;
import com.hotels.styx.routing.config.StyxObjectDefinition;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;

public class HostProxy
implements RoutingObject {
    public static final Schema.FieldType SCHEMA = SchemaDsl.object((SchemaDirective[])new SchemaDirective[]{SchemaDsl.field((String)"host", (Schema.FieldType)SchemaDsl.string()), SchemaDsl.optional((String)"tlsSettings", (Schema.FieldType)SchemaDsl.object((SchemaDirective[])new SchemaDirective[]{SchemaDsl.optional((String)"trustAllCerts", (Schema.FieldType)SchemaDsl.bool()), SchemaDsl.optional((String)"sslProvider", (Schema.FieldType)SchemaDsl.string()), SchemaDsl.optional((String)"trustStorePath", (Schema.FieldType)SchemaDsl.string()), SchemaDsl.optional((String)"trustStorePassword", (Schema.FieldType)SchemaDsl.string()), SchemaDsl.optional((String)"protocols", (Schema.FieldType)SchemaDsl.list((Schema.FieldType)SchemaDsl.string())), SchemaDsl.optional((String)"cipherSuites", (Schema.FieldType)SchemaDsl.list((Schema.FieldType)SchemaDsl.string())), SchemaDsl.optional((String)"additionalCerts", (Schema.FieldType)SchemaDsl.list((Schema.FieldType)SchemaDsl.object((SchemaDirective[])new SchemaDirective[]{SchemaDsl.field((String)"alias", (Schema.FieldType)SchemaDsl.string()), SchemaDsl.field((String)"certificatePath", (Schema.FieldType)SchemaDsl.string())}))), SchemaDsl.atLeastOne((String[])new String[]{"trustAllCerts", "trustStorePath", "trustStorePassword", "protocols", "cipherSuites", "additionalCerts"})})), SchemaDsl.optional((String)"connectionPool", (Schema.FieldType)SchemaDsl.object((SchemaDirective[])new SchemaDirective[]{SchemaDsl.optional((String)"maxConnections", (Schema.FieldType)SchemaDsl.integer()), SchemaDsl.optional((String)"maxPendingConnections", (Schema.FieldType)SchemaDsl.integer()), SchemaDsl.optional((String)"connectTimeoutMillis", (Schema.FieldType)SchemaDsl.integer()), SchemaDsl.optional((String)"socketTimeoutMillis", (Schema.FieldType)SchemaDsl.integer()), SchemaDsl.optional((String)"pendingConnectionTimeoutMillis", (Schema.FieldType)SchemaDsl.integer()), SchemaDsl.optional((String)"connectionExpirationSeconds", (Schema.FieldType)SchemaDsl.integer()), SchemaDsl.atLeastOne((String[])new String[]{"maxConnections", "maxPendingConnections", "connectTimeoutMillis", "socketTimeoutMillis", "pendingConnectionTimeoutMillis", "connectionExpirationSeconds"})})), SchemaDsl.optional((String)"responseTimeoutMillis", (Schema.FieldType)SchemaDsl.integer()), SchemaDsl.optional((String)"maxHeaderSize", (Schema.FieldType)SchemaDsl.integer()), SchemaDsl.optional((String)"metricPrefix", (Schema.FieldType)SchemaDsl.string()), SchemaDsl.optional((String)"executor", (Schema.FieldType)SchemaDsl.string())});
    private final String errorMessage;
    private final StyxHostHttpClient client;
    private final OriginMetrics originMetrics;
    private volatile boolean active = true;
    @VisibleForTesting
    final String host;
    @VisibleForTesting
    final int port;

    public HostProxy(String host, int port, StyxHostHttpClient client2, OriginMetrics originMetrics) {
        this.host = Objects.requireNonNull(host);
        this.port = port;
        this.errorMessage = String.format("HostProxy %s:%d is stopped but received traffic.", host, port);
        this.client = Objects.requireNonNull(client2);
        this.originMetrics = Objects.requireNonNull(originMetrics);
    }

    public Eventual<LiveHttpResponse> handle(LiveHttpRequest request, HttpInterceptor.Context context) {
        if (this.active) {
            return new Eventual((Publisher)ResponseEventListener.from((Publisher)this.client.sendRequest(request, context)).whenCancelled(() -> ((OriginMetrics)this.originMetrics).requestCancelled()).apply());
        }
        return Eventual.error((Throwable)new IllegalStateException(this.errorMessage));
    }

    @Override
    public CompletableFuture<Void> stop() {
        this.active = false;
        this.client.close();
        return CompletableFuture.completedFuture(null);
    }

    public static class Factory
    implements RoutingObjectFactory {
        private static final int DEFAULT_REQUEST_TIMEOUT = 60000;
        private static final int DEFAULT_TLS_PORT = 443;
        private static final int DEFAULT_HTTP_PORT = 80;
        public static final int USE_DEFAULT_MAX_HEADER_SIZE = 0;

        @Override
        public RoutingObject build(List<String> fullName, RoutingObjectFactory.Context context, StyxObjectDefinition configBlock) {
            JsonNodeConfig config = new JsonNodeConfig(configBlock.config());
            ConnectionPoolSettings poolSettings = config.get("connectionPool", ConnectionPoolSettings.class).orElse(ConnectionPoolSettings.defaultConnectionPoolSettings());
            TlsSettings tlsSettings = config.get("tlsSettings", TlsSettings.class).orElse(null);
            int responseTimeoutMillis = config.get("responseTimeoutMillis", Integer.class).orElse(60000);
            int maxHeaderSize = config.get("maxHeaderSize", Integer.class).orElse(0);
            String metricPrefix = config.get("metricPrefix", String.class).orElse("routing.objects");
            String executorName = config.get("executor", String.class).orElse("Styx-Client-Global-Worker");
            String objectName = fullName.get(fullName.size() - 1);
            NettyExecutor executor = (NettyExecutor)((StyxObjectRecord)context.executors().get(executorName).orElseThrow(() -> new IllegalArgumentException(String.format("HostProxy(%s) configuration error: executor='%s' not declared.", objectName, executorName)))).component4();
            HostAndPort hostAndPort = config.get("host").map(HostAndPort::fromString).map(it -> Factory.addDefaultPort(it, tlsSettings)).orElseThrow(() -> RoutingSupport.missingAttributeError(configBlock, String.join((CharSequence)".", fullName), "host"));
            return Factory.createHostProxyHandler(executor, context.environment().metricRegistry(), hostAndPort, poolSettings, tlsSettings, responseTimeoutMillis, maxHeaderSize, metricPrefix, objectName);
        }

        private static HostAndPort addDefaultPort(HostAndPort hostAndPort, TlsSettings tlsSettings) {
            if (hostAndPort.hasPort()) {
                return hostAndPort;
            }
            int defaultPort = Optional.ofNullable(tlsSettings).map(it -> 443).orElse(80);
            return HostAndPort.fromParts((String)hostAndPort.getHostText(), (int)defaultPort);
        }

        @NotNull
        public static HostProxy createHostProxyHandler(NettyExecutor executor, MetricRegistry metricRegistry, HostAndPort hostAndPort, ConnectionPoolSettings poolSettings, TlsSettings tlsSettings, int responseTimeoutMillis, int maxHeaderSize, String metricPrefix, String objectName) {
            String host = hostAndPort.getHostText();
            int port = hostAndPort.getPort();
            Origin origin = Origin.newOriginBuilder((String)host, (int)port).applicationId(metricPrefix).id(objectName).build();
            OriginMetrics originMetrics = OriginMetrics.create((Id)Id.id((String)metricPrefix), (String)objectName, (MetricRegistry)metricRegistry);
            SimpleConnectionPoolFactory connectionPoolFactory = new SimpleConnectionPoolFactory.Builder().connectionFactory(Factory.connectionFactory(executor, tlsSettings, responseTimeoutMillis, maxHeaderSize, theOrigin -> originMetrics, poolSettings.connectionExpirationSeconds())).connectionPoolSettings(poolSettings).metricRegistry(metricRegistry).build();
            return new HostProxy(host, port, StyxHostHttpClient.create((ConnectionPool)connectionPoolFactory.create(origin)), originMetrics);
        }

        private static Connection.Factory connectionFactory(NettyExecutor executor, TlsSettings tlsSettings, int responseTimeoutMillis, int maxHeaderSize, OriginStatsFactory originStatsFactory, long connectionExpiration) {
            NettyConnectionFactory factory = new NettyConnectionFactory.Builder().httpRequestOperationFactory(HttpRequestOperationFactory.Builder.httpRequestOperationFactoryBuilder().flowControlEnabled(true).originStatsFactory(originStatsFactory).responseTimeoutMillis(responseTimeoutMillis).build()).executor(executor).tlsSettings(tlsSettings).httpConfig(HttpConfig.newHttpConfigBuilder().setMaxHeadersSize(maxHeaderSize).build()).build();
            if (connectionExpiration > 0L) {
                return new ExpiringConnectionFactory(connectionExpiration, (Connection.Factory)factory);
            }
            return factory;
        }
    }

    public static class HostProxyConfiguration {
        private final String host;
        private final ConnectionPoolSettings connectionPool;
        private final TlsSettings tlsSettings;
        private final int responseTimeoutMillis;
        private final int maxHeaderSize;
        private final String metricPrefix;
        private final String executor;

        public HostProxyConfiguration(String host, ConnectionPoolSettings connectionPool, TlsSettings tlsSettings, int responseTimeoutMillis, int maxHeaderSize, String metricPrefix, String executor) {
            this.host = host;
            this.connectionPool = connectionPool;
            this.tlsSettings = tlsSettings;
            this.responseTimeoutMillis = responseTimeoutMillis;
            this.maxHeaderSize = maxHeaderSize;
            this.metricPrefix = metricPrefix;
            this.executor = executor;
        }

        @JsonProperty(value="host")
        public String host() {
            return this.host;
        }

        @JsonProperty(value="connectionPool")
        public ConnectionPoolSettings connectionPool() {
            return this.connectionPool;
        }

        @JsonProperty(value="tlsSettings")
        public TlsSettings tlsSettings() {
            return this.tlsSettings;
        }

        @JsonProperty(value="responseTimeoutMillis")
        public int responseTimeoutMillis() {
            return this.responseTimeoutMillis;
        }

        @JsonProperty(value="maxHeaderSize")
        public int maxHeaderSize() {
            return this.maxHeaderSize;
        }

        @JsonProperty(value="metricPrefix")
        public String metricPrefix() {
            return this.metricPrefix;
        }

        @JsonProperty(value="executor")
        public String executor() {
            return this.executor;
        }
    }
}

