/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.routing.handlers;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import com.hotels.styx.api.Eventual;
import com.hotels.styx.api.HttpInterceptor;
import com.hotels.styx.api.LiveHttpRequest;
import com.hotels.styx.api.LiveHttpResponse;
import com.hotels.styx.config.schema.Schema;
import com.hotels.styx.config.schema.SchemaDirective;
import com.hotels.styx.config.schema.SchemaDsl;
import com.hotels.styx.infrastructure.configuration.yaml.JsonNodeConfig;
import com.hotels.styx.proxy.plugin.NamedPlugin;
import com.hotels.styx.routing.RoutingObject;
import com.hotels.styx.routing.config.Builtins;
import com.hotels.styx.routing.config.HttpInterceptorFactory;
import com.hotels.styx.routing.config.RoutingConfigParser;
import com.hotels.styx.routing.config.RoutingObjectFactory;
import com.hotels.styx.routing.config.RoutingSupport;
import com.hotels.styx.routing.config.StyxObjectConfiguration;
import com.hotels.styx.routing.config.StyxObjectDefinition;
import com.hotels.styx.routing.config.StyxObjectReference;
import com.hotels.styx.routing.handlers.StandardHttpPipeline;
import com.hotels.styx.server.track.CurrentRequestTracker;
import com.hotels.styx.server.track.RequestTracker;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class HttpInterceptorPipeline
implements RoutingObject {
    public static final Schema.FieldType SCHEMA = SchemaDsl.object((SchemaDirective[])new SchemaDirective[]{SchemaDsl.optional((String)"pipeline", (Schema.FieldType)SchemaDsl.or((Schema.FieldType)SchemaDsl.string(), (Schema.FieldType)SchemaDsl.list((Schema.FieldType)SchemaDsl.string()))), SchemaDsl.field((String)"handler", (Schema.FieldType)SchemaDsl.routingObject())});
    private final RoutingObject handler;
    private final StandardHttpPipeline pipeline;

    public HttpInterceptorPipeline(List<HttpInterceptor> interceptors, RoutingObject handler, boolean trackRequests) {
        CurrentRequestTracker tracker = trackRequests ? CurrentRequestTracker.INSTANCE : RequestTracker.NO_OP;
        this.handler = Objects.requireNonNull(handler);
        this.pipeline = new StandardHttpPipeline(interceptors, handler, (RequestTracker)tracker);
    }

    public Eventual<LiveHttpResponse> handle(LiveHttpRequest request, HttpInterceptor.Context context) {
        return this.pipeline.handle(request, context);
    }

    @Override
    public CompletableFuture<Void> stop() {
        return this.handler.stop();
    }

    public static class Factory
    implements RoutingObjectFactory {
        @Override
        public RoutingObject build(List<String> fullName, RoutingObjectFactory.Context context, StyxObjectDefinition configBlock) {
            JsonNode pipeline = configBlock.config().get("pipeline");
            List<HttpInterceptor> interceptors = Factory.getHttpInterceptors(RoutingSupport.append(fullName, "pipeline"), Factory.toMap(context.plugins()), context.interceptorFactories(), pipeline);
            JsonNode handlerConfig = new JsonNodeConfig(configBlock.config()).get("handler", JsonNode.class).orElseThrow(() -> RoutingSupport.missingAttributeError(configBlock, String.join((CharSequence)".", fullName), "handler"));
            return new HttpInterceptorPipeline(interceptors, Builtins.build(RoutingSupport.append(fullName, "handler"), context, RoutingConfigParser.toRoutingConfigNode(handlerConfig)), context.requestTracking());
        }

        private static List<HttpInterceptor> getHttpInterceptors(List<String> parents, Map<String, NamedPlugin> plugins, Map<String, HttpInterceptorFactory> interceptorFactories, JsonNode pipeline) {
            if (pipeline == null || pipeline.isNull()) {
                return ImmutableList.of();
            }
            List<StyxObjectConfiguration> interceptorConfigs = Factory.styxHttpPipeline(pipeline);
            Factory.ensureValidPluginReferences(parents, plugins, interceptorConfigs);
            return interceptorConfigs.stream().map(node -> {
                if (node instanceof StyxObjectReference) {
                    String name = ((StyxObjectReference)node).name();
                    return (HttpInterceptor)plugins.get(name);
                }
                StyxObjectDefinition block = (StyxObjectDefinition)node;
                return Builtins.build(block, interceptorFactories);
            }).collect(Collectors.toList());
        }

        private static List<StyxObjectConfiguration> styxHttpPipeline(JsonNode pipeline) {
            if (pipeline.isTextual()) {
                String[] names = pipeline.textValue().split(",");
                return Arrays.stream(names).map(String::trim).filter(it -> !it.isEmpty()).map(StyxObjectReference::new).collect(Collectors.toList());
            }
            return StreamSupport.stream(pipeline.spliterator(), false).map(RoutingConfigParser::toRoutingConfigNode).collect(Collectors.toList());
        }

        private static void ensureValidPluginReferences(List<String> parents, Map<String, NamedPlugin> plugins, List<StyxObjectConfiguration> interceptors) {
            interceptors.forEach(node -> {
                String name;
                if (node instanceof StyxObjectReference && !plugins.containsKey(name = ((StyxObjectReference)node).name())) {
                    throw new IllegalArgumentException(String.format("No such plugin or interceptor exists, attribute='%s', name='%s'", String.join((CharSequence)".", parents), name));
                }
            });
        }

        private static Map<String, NamedPlugin> toMap(Iterable<NamedPlugin> plugins) {
            return StreamSupport.stream(plugins.spliterator(), false).collect(Collectors.toMap(NamedPlugin::name, Function.identity()));
        }
    }
}

