/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.routing.handlers;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.hotels.styx.ObjectTagsKt;
import com.hotels.styx.api.Eventual;
import com.hotels.styx.api.HttpHandler;
import com.hotels.styx.api.HttpInterceptor;
import com.hotels.styx.api.Id;
import com.hotels.styx.api.LiveHttpRequest;
import com.hotels.styx.api.LiveHttpResponse;
import com.hotels.styx.api.configuration.ObjectStore;
import com.hotels.styx.api.extension.ActiveOrigins;
import com.hotels.styx.api.extension.Origin;
import com.hotels.styx.api.extension.RemoteHost;
import com.hotels.styx.api.extension.loadbalancing.spi.LoadBalancer;
import com.hotels.styx.api.extension.loadbalancing.spi.LoadBalancingMetric;
import com.hotels.styx.api.extension.loadbalancing.spi.LoadBalancingMetricSupplier;
import com.hotels.styx.api.extension.service.StickySessionConfig;
import com.hotels.styx.client.OriginRestrictionLoadBalancingStrategy;
import com.hotels.styx.client.StyxBackendServiceClient;
import com.hotels.styx.client.loadbalancing.strategies.PowerOfTwoStrategy;
import com.hotels.styx.client.stickysession.StickySessionLoadBalancingStrategy;
import com.hotels.styx.config.schema.Schema;
import com.hotels.styx.config.schema.SchemaDirective;
import com.hotels.styx.config.schema.SchemaDsl;
import com.hotels.styx.infrastructure.configuration.yaml.JsonNodeConfig;
import com.hotels.styx.routing.RoutingMetadataDecorator;
import com.hotels.styx.routing.RoutingObject;
import com.hotels.styx.routing.RoutingObjectRecord;
import com.hotels.styx.routing.config.RoutingObjectFactory;
import com.hotels.styx.routing.config.StyxObjectDefinition;
import com.hotels.styx.routing.db.StyxObjectStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.FluxExtensionsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0003\u0016\u0017\u0018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\u000b\u001a\u0010\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r0\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0019"}, d2={"Lcom/hotels/styx/routing/handlers/LoadBalancingGroup;", "Lcom/hotels/styx/routing/RoutingObject;", "client", "Lcom/hotels/styx/client/StyxBackendServiceClient;", "changeWatcher", "Lreactor/core/Disposable;", "(Lcom/hotels/styx/client/StyxBackendServiceClient;Lreactor/core/Disposable;)V", "getChangeWatcher", "()Lreactor/core/Disposable;", "getClient", "()Lcom/hotels/styx/client/StyxBackendServiceClient;", "handle", "Lcom/hotels/styx/api/Eventual;", "Lcom/hotels/styx/api/LiveHttpResponse;", "kotlin.jvm.PlatformType", "request", "Lcom/hotels/styx/api/LiveHttpRequest;", "context", "Lcom/hotels/styx/api/HttpInterceptor$Context;", "stop", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "Companion", "Config", "Factory", "styx-proxy"})
public final class LoadBalancingGroup
implements RoutingObject {
    @NotNull
    private final StyxBackendServiceClient client;
    @NotNull
    private final Disposable changeWatcher;
    private static final Schema.FieldType SCHEMA;
    private static final Logger LOGGER;
    public static final Companion Companion;

    @NotNull
    public Eventual<LiveHttpResponse> handle(@NotNull LiveHttpRequest request, @NotNull HttpInterceptor.Context context) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return new Eventual(this.client.sendRequest(request, context));
    }

    @Override
    @NotNull
    public CompletableFuture<Void> stop() {
        this.changeWatcher.dispose();
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        Intrinsics.checkExpressionValueIsNotNull(completableFuture, (String)"completedFuture(null)");
        return completableFuture;
    }

    @NotNull
    public final StyxBackendServiceClient getClient() {
        return this.client;
    }

    @NotNull
    public final Disposable getChangeWatcher() {
        return this.changeWatcher;
    }

    public LoadBalancingGroup(@NotNull StyxBackendServiceClient client2, @NotNull Disposable changeWatcher) {
        Intrinsics.checkParameterIsNotNull((Object)client2, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)changeWatcher, (String)"changeWatcher");
        this.client = client2;
        this.changeWatcher = changeWatcher;
    }

    static {
        Companion = new Companion(null);
        SCHEMA = SchemaDsl.object((SchemaDirective[])new SchemaDirective[]{(SchemaDirective)SchemaDsl.field((String)"origins", (Schema.FieldType)SchemaDsl.string()), (SchemaDirective)SchemaDsl.optional((String)"originRestrictionCookie", (Schema.FieldType)SchemaDsl.string()), (SchemaDirective)SchemaDsl.optional((String)"stickySession", (Schema.FieldType)SchemaDsl.object((SchemaDirective[])new SchemaDirective[]{(SchemaDirective)SchemaDsl.field((String)"enabled", (Schema.FieldType)SchemaDsl.bool()), (SchemaDirective)SchemaDsl.field((String)"timeoutSeconds", (Schema.FieldType)SchemaDsl.integer())}))});
        LOGGER = LoggerFactory.getLogger(LoadBalancingGroup.class);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010&\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J2\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00072\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0012\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u0019H\u0002J$\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u00072\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00170\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u0007H\u0002J\u0018\u0010!\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u00072\u0006\u0010\"\u001a\u00020#H\u0002\u00a8\u0006$"}, d2={"Lcom/hotels/styx/routing/handlers/LoadBalancingGroup$Factory;", "Lcom/hotels/styx/routing/config/RoutingObjectFactory;", "()V", "build", "Lcom/hotels/styx/routing/RoutingObject;", "fullName", "", "", "context", "Lcom/hotels/styx/routing/config/RoutingObjectFactory$Context;", "configBlock", "Lcom/hotels/styx/routing/config/StyxObjectDefinition;", "loadBalancer", "Lcom/hotels/styx/api/extension/loadbalancing/spi/LoadBalancer;", "config", "Lcom/hotels/styx/routing/handlers/LoadBalancingGroup$Config;", "activeOrigins", "Lcom/hotels/styx/api/extension/ActiveOrigins;", "routeDatabaseChanged", "", "appId", "snapshot", "Lcom/hotels/styx/api/configuration/ObjectStore;", "Lcom/hotels/styx/routing/RoutingObjectRecord;", "remoteHosts", "Ljava/util/concurrent/atomic/AtomicReference;", "", "Lcom/hotels/styx/api/extension/RemoteHost;", "toRemoteHost", "record", "", "watchCompleted", "name", "watchFailed", "cause", "", "styx-proxy"})
    public static final class Factory
    implements RoutingObjectFactory {
        @Override
        @NotNull
        public RoutingObject build(@NotNull List<String> fullName, @NotNull RoutingObjectFactory.Context context, @NotNull StyxObjectDefinition configBlock) {
            StyxBackendServiceClient client2;
            Set set;
            Intrinsics.checkParameterIsNotNull(fullName, (String)"fullName");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)configBlock, (String)"configBlock");
            String appId = (String)CollectionsKt.last(fullName);
            Config config = new JsonNodeConfig(configBlock.config()).as(Config.class);
            StyxObjectStore<RoutingObjectRecord> routeDb = context.routeDb();
            boolean bl = false;
            Set set2 = set = SetsKt.emptySet();
            AtomicReference<Set> remoteHosts = new AtomicReference<Set>(set2);
            Disposable watch2 = FluxExtensionsKt.toFlux(routeDb.watch()).subscribe((Consumer)new Consumer<ObjectStore<RoutingObjectRecord>>(this, config, remoteHosts){
                final /* synthetic */ Factory this$0;
                final /* synthetic */ Config $config;
                final /* synthetic */ AtomicReference $remoteHosts;

                public final void accept(ObjectStore<RoutingObjectRecord> it) {
                    String string = this.$config.getOrigins();
                    ObjectStore<RoutingObjectRecord> objectStore = it;
                    Intrinsics.checkExpressionValueIsNotNull(objectStore, (String)"it");
                    Factory.access$routeDatabaseChanged(this.this$0, string, objectStore, this.$remoteHosts);
                }
                {
                    this.this$0 = factory;
                    this.$config = config;
                    this.$remoteHosts = atomicReference;
                }
            }, (Consumer)new Consumer<Throwable>(this, appId){
                final /* synthetic */ Factory this$0;
                final /* synthetic */ String $appId;

                public final void accept(Throwable it) {
                    Throwable throwable = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"it");
                    Factory.access$watchFailed(this.this$0, this.$appId, throwable);
                }
                {
                    this.this$0 = factory;
                    this.$appId = string;
                }
            }, new Runnable(this, appId){
                final /* synthetic */ Factory this$0;
                final /* synthetic */ String $appId;

                public final void run() {
                    Factory.access$watchCompleted(this.this$0, this.$appId);
                }
                {
                    this.this$0 = factory;
                    this.$appId = string;
                }
            });
            StyxBackendServiceClient.Builder builder = new StyxBackendServiceClient.Builder(Id.id((String)appId));
            Config config2 = config;
            Intrinsics.checkExpressionValueIsNotNull((Object)config2, (String)"config");
            StyxBackendServiceClient.Builder builder2 = builder.loadBalancer(this.loadBalancer(config2, new ActiveOrigins(remoteHosts){
                final /* synthetic */ AtomicReference $remoteHosts;

                public final Set<RemoteHost> snapshot() {
                    return (Set)this.$remoteHosts.get();
                }
                {
                    this.$remoteHosts = atomicReference;
                }
            })).metricsRegistry(context.environment().metricRegistry()).originIdHeader(context.environment().configuration().styxHeaderConfig().originIdHeaderName());
            StickySessionConfig stickySessionConfig = config.getStickySession();
            if (stickySessionConfig == null) {
                stickySessionConfig = StickySessionConfig.stickySessionDisabled();
            }
            StyxBackendServiceClient styxBackendServiceClient = client2 = builder2.stickySessionConfig(stickySessionConfig).originsRestrictionCookieName(config.getOriginRestrictionCookie()).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)styxBackendServiceClient, (String)"client");
            Disposable disposable = watch2;
            Intrinsics.checkExpressionValueIsNotNull((Object)disposable, (String)"watch");
            return new LoadBalancingGroup(styxBackendServiceClient, disposable);
        }

        private final LoadBalancer loadBalancer(Config config, ActiveOrigins activeOrigins) {
            PowerOfTwoStrategy loadBalancer = new PowerOfTwoStrategy(activeOrigins);
            return config.getStickySessionConfig().stickySessionEnabled() ? (LoadBalancer)new StickySessionLoadBalancingStrategy(activeOrigins, (LoadBalancer)loadBalancer) : (config.getOriginRestrictionCookie() == null ? (LoadBalancer)loadBalancer : (LoadBalancer)new OriginRestrictionLoadBalancingStrategy(activeOrigins, (LoadBalancer)loadBalancer));
        }

        /*
         * WARNING - void declaration
         */
        private final void routeDatabaseChanged(String appId, ObjectStore<RoutingObjectRecord> snapshot, AtomicReference<Set<RemoteHost>> remoteHosts) {
            void $this$mapTo$iv$iv;
            Map.Entry it;
            Iterable $this$filterTo$iv$iv;
            Collection collection = snapshot.entrySet();
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"snapshot.entrySet()");
            Iterable $this$filter$iv = collection;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Map.Entry)element$iv$iv;
                boolean bl = false;
                if (!((RoutingObjectRecord)it.getValue()).getTags().contains(ObjectTagsKt.getLbGroupTag().invoke(appId))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Map.Entry)element$iv$iv;
                boolean bl = false;
                Object t = ObjectTagsKt.getStateTag().find(((RoutingObjectRecord)it.getValue()).getTags());
                boolean bl2 = false;
                boolean bl3 = false;
                String it2 = (String)t;
                boolean bl4 = false;
                boolean bl5 = it2 == null || Intrinsics.areEqual((Object)it2, (Object)"active");
                if (!bl5) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Map.Entry)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)entry, (String)"it");
                RemoteHost remoteHost = this.toRemoteHost(appId, entry);
                collection2.add(remoteHost);
            }
            Set newSet = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            remoteHosts.set(newSet);
        }

        private final RemoteHost toRemoteHost(String appId, Map.Entry<String, RoutingObjectRecord> record) {
            RoutingMetadataDecorator routingObject = record.getValue().getRoutingObject();
            String originName = record.getKey();
            RemoteHost remoteHost = RemoteHost.remoteHost((Origin)Origin.newOriginBuilder((String)"NA", (int)0).applicationId(appId).id(originName).build(), (HttpHandler)routingObject, (LoadBalancingMetricSupplier)new LoadBalancingMetricSupplier(routingObject){
                final /* synthetic */ RoutingMetadataDecorator $routingObject;

                public final LoadBalancingMetric loadBalancingMetric() {
                    return this.$routingObject.metric();
                }
                {
                    this.$routingObject = routingMetadataDecorator;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)remoteHost, (String)"remoteHost(\n            \u2026routingObject.metric() })");
            return remoteHost;
        }

        private final void watchFailed(String name, Throwable cause) {
            LOGGER.error("{}: Illegal state: watch error. Cause={}", (Object)name, (Object)cause);
        }

        private final void watchCompleted(String name) {
            LOGGER.error("{}: Illegal state: watch completed", (Object)name);
        }

        public static final /* synthetic */ void access$routeDatabaseChanged(Factory $this, String appId, ObjectStore snapshot, AtomicReference remoteHosts) {
            $this.routeDatabaseChanged(appId, (ObjectStore<RoutingObjectRecord>)snapshot, remoteHosts);
        }

        public static final /* synthetic */ void access$watchFailed(Factory $this, String name, Throwable cause) {
            $this.watchFailed(name, cause);
        }

        public static final /* synthetic */ void access$watchCompleted(Factory $this, String name) {
            $this.watchCompleted(name);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0001\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0001\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J+\u0010\u0012\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\n\b\u0003\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0003\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u0019"}, d2={"Lcom/hotels/styx/routing/handlers/LoadBalancingGroup$Config;", "", "origins", "", "originRestrictionCookie", "stickySession", "Lcom/hotels/styx/api/extension/service/StickySessionConfig;", "(Ljava/lang/String;Ljava/lang/String;Lcom/hotels/styx/api/extension/service/StickySessionConfig;)V", "getOriginRestrictionCookie", "()Ljava/lang/String;", "getOrigins", "getStickySession", "()Lcom/hotels/styx/api/extension/service/StickySessionConfig;", "stickySessionConfig", "getStickySessionConfig", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "styx-proxy"})
    public static final class Config {
        @NotNull
        private final String origins;
        @Nullable
        private final String originRestrictionCookie;
        @Nullable
        private final StickySessionConfig stickySession;

        @NotNull
        public final StickySessionConfig getStickySessionConfig() {
            StickySessionConfig stickySessionConfig = this.stickySession;
            if (stickySessionConfig == null) {
                StickySessionConfig stickySessionConfig2 = StickySessionConfig.stickySessionDisabled();
                stickySessionConfig = stickySessionConfig2;
                Intrinsics.checkExpressionValueIsNotNull((Object)stickySessionConfig2, (String)"StickySessionConfig.stickySessionDisabled()");
            }
            return stickySessionConfig;
        }

        @NotNull
        public final String getOrigins() {
            return this.origins;
        }

        @Nullable
        public final String getOriginRestrictionCookie() {
            return this.originRestrictionCookie;
        }

        @Nullable
        public final StickySessionConfig getStickySession() {
            return this.stickySession;
        }

        public Config(@JsonProperty @NotNull String origins, @JsonProperty @Nullable String originRestrictionCookie, @JsonProperty @Nullable StickySessionConfig stickySession) {
            Intrinsics.checkParameterIsNotNull((Object)origins, (String)"origins");
            this.origins = origins;
            this.originRestrictionCookie = originRestrictionCookie;
            this.stickySession = stickySession;
        }

        @NotNull
        public final String component1() {
            return this.origins;
        }

        @Nullable
        public final String component2() {
            return this.originRestrictionCookie;
        }

        @Nullable
        public final StickySessionConfig component3() {
            return this.stickySession;
        }

        @NotNull
        public final Config copy(@JsonProperty @NotNull String origins, @JsonProperty @Nullable String originRestrictionCookie, @JsonProperty @Nullable StickySessionConfig stickySession) {
            Intrinsics.checkParameterIsNotNull((Object)origins, (String)"origins");
            return new Config(origins, originRestrictionCookie, stickySession);
        }

        public static /* synthetic */ Config copy$default(Config config, String string, String string2, StickySessionConfig stickySessionConfig, int n, Object object) {
            if ((n & 1) != 0) {
                string = config.origins;
            }
            if ((n & 2) != 0) {
                string2 = config.originRestrictionCookie;
            }
            if ((n & 4) != 0) {
                stickySessionConfig = config.stickySession;
            }
            return config.copy(string, string2, stickySessionConfig);
        }

        @NotNull
        public String toString() {
            return "Config(origins=" + this.origins + ", originRestrictionCookie=" + this.originRestrictionCookie + ", stickySession=" + this.stickySession + ")";
        }

        public int hashCode() {
            String string = this.origins;
            String string2 = this.originRestrictionCookie;
            StickySessionConfig stickySessionConfig = this.stickySession;
            return ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (stickySessionConfig != null ? stickySessionConfig.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Config)) break block3;
                    Config config = (Config)object;
                    if (!Intrinsics.areEqual((Object)this.origins, (Object)config.origins) || !Intrinsics.areEqual((Object)this.originRestrictionCookie, (Object)config.originRestrictionCookie) || !Intrinsics.areEqual((Object)this.stickySession, (Object)config.stickySession)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/hotels/styx/routing/handlers/LoadBalancingGroup$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "SCHEMA", "Lcom/hotels/styx/config/schema/Schema$FieldType;", "getSCHEMA", "()Lcom/hotels/styx/config/schema/Schema$FieldType;", "styx-proxy"})
    public static final class Companion {
        public final Schema.FieldType getSCHEMA() {
            return SCHEMA;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

