/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.routing.handlers;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import com.hotels.styx.api.Eventual;
import com.hotels.styx.api.HttpInterceptor;
import com.hotels.styx.api.LiveHttpRequest;
import com.hotels.styx.api.LiveHttpResponse;
import com.hotels.styx.common.Pair;
import com.hotels.styx.config.schema.Schema;
import com.hotels.styx.config.schema.SchemaDirective;
import com.hotels.styx.config.schema.SchemaDsl;
import com.hotels.styx.infrastructure.configuration.yaml.JsonNodeConfig;
import com.hotels.styx.routing.RoutingObject;
import com.hotels.styx.routing.config.Builtins;
import com.hotels.styx.routing.config.RoutingConfigParser;
import com.hotels.styx.routing.config.RoutingObjectFactory;
import com.hotels.styx.routing.config.RoutingSupport;
import com.hotels.styx.routing.config.StyxObjectConfiguration;
import com.hotels.styx.routing.config.StyxObjectDefinition;
import com.hotels.styx.server.NoServiceConfiguredException;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.stream.Collectors;

public class PathPrefixRouter {
    public static final Schema.FieldType SCHEMA = SchemaDsl.object((SchemaDirective[])new SchemaDirective[]{SchemaDsl.field((String)"routes", (Schema.FieldType)SchemaDsl.list((Schema.FieldType)SchemaDsl.object((SchemaDirective[])new SchemaDirective[]{SchemaDsl.field((String)"prefix", (Schema.FieldType)SchemaDsl.string()), SchemaDsl.field((String)"destination", (Schema.FieldType)SchemaDsl.routingObject())})))});
    private final ConcurrentSkipListMap<String, RoutingObject> routes = new ConcurrentSkipListMap(Comparator.comparingInt(String::length).reversed().thenComparing(Comparator.naturalOrder()));

    PathPrefixRouter(List<Pair<String, RoutingObject>> routes) {
        routes.forEach(entry -> this.routes.put((String)entry.key(), (RoutingObject)entry.value()));
    }

    public Optional<RoutingObject> route(LiveHttpRequest request) {
        String path = request.path();
        return this.routes.entrySet().stream().filter(entry -> path.startsWith((String)entry.getKey())).findFirst().map(Map.Entry::getValue);
    }

    public static class PathPrefixRouterConfig {
        private final List<PathPrefixConfig> routes;

        public PathPrefixRouterConfig(@JsonProperty(value="routes") List<PathPrefixConfig> routes) {
            this.routes = routes;
        }

        public List<PathPrefixConfig> routes() {
            return this.routes;
        }
    }

    public static class PathPrefixConfig {
        private final String prefix;
        private final StyxObjectConfiguration destination;

        public PathPrefixConfig(@JsonProperty(value="prefix") String prefix, @JsonProperty(value="destination") JsonNode destination) {
            this.prefix = prefix;
            this.destination = RoutingConfigParser.toRoutingConfigNode(destination);
        }

        public String prefix() {
            return this.prefix;
        }

        public StyxObjectConfiguration destination() {
            return this.destination;
        }
    }

    public static class Factory
    implements RoutingObjectFactory {
        @Override
        public RoutingObject build(List<String> fullName, RoutingObjectFactory.Context context, StyxObjectDefinition configBlock) {
            PathPrefixRouterConfig config = new JsonNodeConfig(configBlock.config()).as(PathPrefixRouterConfig.class);
            if (config.routes == null) {
                throw RoutingSupport.missingAttributeError(configBlock, String.join((CharSequence)".", fullName), "routes");
            }
            final PathPrefixRouter pathPrefixRouter = new PathPrefixRouter(config.routes.stream().map(route -> Pair.pair((Object)((PathPrefixConfig)route).prefix, (Object)Builtins.build((List<String>)ImmutableList.of((Object)""), context, ((PathPrefixConfig)route).destination))).collect(Collectors.toList()));
            return new RoutingObject(){

                public Eventual<LiveHttpResponse> handle(LiveHttpRequest request, HttpInterceptor.Context context) {
                    return pathPrefixRouter.route(request).orElse((x, y) -> Eventual.error((Throwable)new NoServiceConfiguredException(request.path()))).handle(request, context);
                }

                @Override
                public CompletableFuture<Void> stop() {
                    pathPrefixRouter.routes.forEach((route, routingObject) -> routingObject.stop());
                    return CompletableFuture.completedFuture(null);
                }
            };
        }
    }
}

