/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.routing.handlers;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.hotels.styx.NettyExecutor;
import com.hotels.styx.api.Eventual;
import com.hotels.styx.api.HttpInterceptor;
import com.hotels.styx.api.LiveHttpRequest;
import com.hotels.styx.api.LiveHttpResponse;
import com.hotels.styx.api.extension.service.BackendService;
import com.hotels.styx.api.extension.service.ConnectionPoolSettings;
import com.hotels.styx.api.extension.service.TlsSettings;
import com.hotels.styx.client.BackendServiceClient;
import com.hotels.styx.client.Connection;
import com.hotels.styx.client.HttpConfig;
import com.hotels.styx.client.HttpRequestOperationFactory;
import com.hotels.styx.client.OriginStatsFactory;
import com.hotels.styx.client.OriginsInventory;
import com.hotels.styx.client.connectionpool.ConnectionPool;
import com.hotels.styx.client.connectionpool.ExpiringConnectionFactory;
import com.hotels.styx.client.connectionpool.SimpleConnectionPoolFactory;
import com.hotels.styx.client.netty.connectionpool.NettyConnectionFactory;
import com.hotels.styx.config.schema.Schema;
import com.hotels.styx.config.schema.SchemaDirective;
import com.hotels.styx.config.schema.SchemaDsl;
import com.hotels.styx.infrastructure.configuration.yaml.JsonNodeConfig;
import com.hotels.styx.proxy.BackendServiceClientFactory;
import com.hotels.styx.proxy.StyxBackendServiceClientFactory;
import com.hotels.styx.routing.RoutingObject;
import com.hotels.styx.routing.config.RoutingObjectFactory;
import com.hotels.styx.routing.config.RoutingSupport;
import com.hotels.styx.routing.config.StyxObjectDefinition;
import java.util.List;

@Deprecated
public class ProxyToBackend
implements RoutingObject {
    public static final Schema.FieldType SCHEMA = SchemaDsl.object((SchemaDirective[])new SchemaDirective[]{SchemaDsl.field((String)"backend", (Schema.FieldType)SchemaDsl.object((SchemaDirective[])new SchemaDirective[]{SchemaDsl.opaque()}))});
    private final BackendServiceClient client;

    private ProxyToBackend(BackendServiceClient client2) {
        this.client = client2;
    }

    public Eventual<LiveHttpResponse> handle(LiveHttpRequest request, HttpInterceptor.Context context) {
        return new Eventual(this.client.sendRequest(request, context));
    }

    public static class Factory
    implements RoutingObjectFactory {
        @VisibleForTesting
        static RoutingObject build(List<String> parents, RoutingObjectFactory.Context context, StyxObjectDefinition configBlock, BackendServiceClientFactory clientFactory) {
            JsonNodeConfig jsConfig = new JsonNodeConfig(configBlock.config());
            BackendService backendService = jsConfig.get("backend", BackendService.class).orElseThrow(() -> RoutingSupport.missingAttributeError(configBlock, String.join((CharSequence)".", parents), "backend"));
            int clientWorkerThreadsCount = context.environment().configuration().proxyServerConfig().clientWorkerThreadsCount();
            boolean requestLoggingEnabled = context.environment().configuration().get("request-logging.outbound.enabled", Boolean.class).orElse(false);
            boolean longFormat = context.environment().configuration().get("request-logging.outbound.longFormat", Boolean.class).orElse(false);
            JsonNode origins = jsConfig.get("backend.origins", JsonNode.class).orElseThrow(() -> RoutingSupport.missingAttributeError(configBlock, String.join((CharSequence)".", RoutingSupport.append(parents, "backend")), "origins"));
            OriginStatsFactory.CachingOriginStatsFactory originStatsFactory = new OriginStatsFactory.CachingOriginStatsFactory(context.environment().metricRegistry());
            NettyConnectionFactory connectionFactory = new NettyConnectionFactory.Builder().executor(NettyExecutor.create((String)"Styx", (int)clientWorkerThreadsCount)).httpRequestOperationFactory(HttpRequestOperationFactory.Builder.httpRequestOperationFactoryBuilder().flowControlEnabled(true).originStatsFactory((OriginStatsFactory)originStatsFactory).requestLoggingEnabled(requestLoggingEnabled).responseTimeoutMillis(backendService.responseTimeoutMillis()).longFormat(longFormat).build()).tlsSettings((TlsSettings)backendService.tlsSettings().orElse(null)).httpConfig(HttpConfig.newHttpConfigBuilder().setMaxHeadersSize(backendService.maxHeaderSize()).build()).build();
            ConnectionPoolSettings poolSettings = backendService.connectionPoolConfig();
            if (poolSettings.connectionExpirationSeconds() > 0L) {
                connectionFactory = new ExpiringConnectionFactory(poolSettings.connectionExpirationSeconds(), (Connection.Factory)connectionFactory);
            }
            SimpleConnectionPoolFactory connectionPoolFactory = new SimpleConnectionPoolFactory.Builder().connectionFactory((Connection.Factory)connectionFactory).connectionPoolSettings(poolSettings).metricRegistry(context.environment().metricRegistry()).build();
            OriginsInventory inventory = new OriginsInventory.Builder(backendService.id()).eventBus(context.environment().eventBus()).metricsRegistry(context.environment().metricRegistry()).connectionPoolFactory((ConnectionPool.Factory)connectionPoolFactory).initialOrigins(backendService.origins()).build();
            return new ProxyToBackend(clientFactory.createClient(backendService, inventory, (OriginStatsFactory)originStatsFactory));
        }

        @Override
        public RoutingObject build(List<String> fullName, RoutingObjectFactory.Context context, StyxObjectDefinition configBlock) {
            return Factory.build(fullName, context, configBlock, new StyxBackendServiceClientFactory(context.environment()));
        }
    }
}

