/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.routing.handlers;

import com.hotels.styx.api.Eventual;
import com.hotels.styx.api.HttpResponse;
import com.hotels.styx.api.HttpResponseStatus;
import com.hotels.styx.routing.RoutingObject;
import com.hotels.styx.routing.RoutingObjectRecord;
import com.hotels.styx.routing.config.StyxObjectReference;
import com.hotels.styx.routing.db.StyxObjectStore;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;

public interface RouteRefLookup {
    public RoutingObject apply(StyxObjectReference var1);

    public static class RouteDbRefLookup
    implements RouteRefLookup {
        private final StyxObjectStore<RoutingObjectRecord> routeDatabase;

        public RouteDbRefLookup(StyxObjectStore<RoutingObjectRecord> routeDatabase) {
            this.routeDatabase = Objects.requireNonNull(routeDatabase);
        }

        @Override
        public RoutingObject apply(StyxObjectReference route) {
            Optional<RoutingObjectRecord> routingObjectRecord = this.routeDatabase.get(route.name());
            return routingObjectRecord.map(it -> it.getRoutingObject()).orElse((liveRequest, na) -> {
                liveRequest.consume();
                return Eventual.of((Object)HttpResponse.response((HttpResponseStatus)HttpResponseStatus.NOT_FOUND).body("Not found: " + route.name(), StandardCharsets.UTF_8).build().stream());
            });
        }
    }
}

