/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.routing.handlers;

import com.hotels.styx.api.Eventual;
import com.hotels.styx.api.HttpHandler;
import com.hotels.styx.api.HttpInterceptor;
import com.hotels.styx.api.LiveHttpRequest;
import com.hotels.styx.api.LiveHttpResponse;
import com.hotels.styx.server.track.RequestTracker;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

class StandardHttpPipeline
implements HttpHandler {
    private final List<HttpInterceptor> interceptors;
    private final HttpHandler handler;
    private final RequestTracker requestTracker;

    public StandardHttpPipeline(HttpHandler handler) {
        this(Collections.emptyList(), handler, RequestTracker.NO_OP);
    }

    public StandardHttpPipeline(List<HttpInterceptor> interceptors, HttpHandler handler, RequestTracker requestTracker) {
        this.interceptors = Objects.requireNonNull(interceptors);
        this.handler = Objects.requireNonNull(handler);
        this.requestTracker = Objects.requireNonNull(requestTracker);
    }

    public Eventual<LiveHttpResponse> handle(LiveHttpRequest request, HttpInterceptor.Context context) {
        HttpInterceptorChain interceptorsChain = new HttpInterceptorChain(this.interceptors, 0, this.handler, context, this.requestTracker);
        return interceptorsChain.proceed(request);
    }

    private static final class SingleSubscriptionPublisher
    implements Publisher<LiveHttpResponse> {
        private AtomicInteger subscriptionCounter = new AtomicInteger();
        private Publisher<LiveHttpResponse> original;

        public SingleSubscriptionPublisher(Publisher<LiveHttpResponse> original) {
            this.original = original;
        }

        public void subscribe(Subscriber<? super LiveHttpResponse> subscriber) {
            if (this.subscriptionCounter.incrementAndGet() > 1) {
                subscriber.onError((Throwable)new IllegalStateException("Response already subscribed. Additional subscriptions forbidden."));
            } else {
                this.original.subscribe(subscriber);
            }
        }
    }

    static final class HttpInterceptorChain
    implements HttpInterceptor.Chain {
        private final List<HttpInterceptor> interceptors;
        private final int index;
        private final HttpHandler client;
        private final HttpInterceptor.Context context;
        private final RequestTracker requestTracker;

        HttpInterceptorChain(List<HttpInterceptor> interceptors, int index, HttpHandler client2, HttpInterceptor.Context context, RequestTracker requestTracker) {
            this.interceptors = interceptors;
            this.index = index;
            this.client = client2;
            this.context = context;
            this.requestTracker = Objects.requireNonNull(requestTracker);
        }

        HttpInterceptorChain(HttpInterceptorChain adapter, int index) {
            this(adapter.interceptors, index, adapter.client, adapter.context, adapter.requestTracker);
        }

        public HttpInterceptor.Context context() {
            return this.context;
        }

        public Eventual<LiveHttpResponse> proceed(LiveHttpRequest request) {
            this.requestTracker.trackRequest(request);
            if (this.index < this.interceptors.size()) {
                HttpInterceptorChain chain = new HttpInterceptorChain(this, this.index + 1);
                HttpInterceptor interceptor = this.interceptors.get(this.index);
                try {
                    return interceptor.intercept(request, (HttpInterceptor.Chain)chain);
                }
                catch (Throwable e) {
                    return Eventual.error((Throwable)e);
                }
            }
            this.requestTracker.markRequestAsSent(request);
            return new Eventual((Publisher)new SingleSubscriptionPublisher((Publisher<LiveHttpResponse>)this.client.handle(request, this.context)));
        }
    }
}

