/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.routing.handlers;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.hotels.styx.api.Buffer;
import com.hotels.styx.api.ByteStream;
import com.hotels.styx.api.Eventual;
import com.hotels.styx.api.HttpHeaders;
import com.hotels.styx.api.HttpInterceptor;
import com.hotels.styx.api.HttpResponseStatus;
import com.hotels.styx.api.LiveHttpRequest;
import com.hotels.styx.api.LiveHttpResponse;
import com.hotels.styx.config.schema.Schema;
import com.hotels.styx.config.schema.SchemaDirective;
import com.hotels.styx.config.schema.SchemaDsl;
import com.hotels.styx.infrastructure.configuration.yaml.JsonNodeConfig;
import com.hotels.styx.routing.RoutingObject;
import com.hotels.styx.routing.config.RoutingObjectFactory;
import com.hotels.styx.routing.config.StyxObjectDefinition;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class StaticResponseHandler
implements RoutingObject {
    public static final Schema.FieldType SCHEMA = SchemaDsl.object((SchemaDirective[])new SchemaDirective[]{SchemaDsl.field((String)"status", (Schema.FieldType)SchemaDsl.integer()), SchemaDsl.optional((String)"content", (Schema.FieldType)SchemaDsl.string()), SchemaDsl.optional((String)"headers", (Schema.FieldType)SchemaDsl.list((Schema.FieldType)SchemaDsl.object((SchemaDirective[])new SchemaDirective[]{SchemaDsl.field((String)"name", (Schema.FieldType)SchemaDsl.string()), SchemaDsl.field((String)"value", (Schema.FieldType)SchemaDsl.string())})))});
    private final int status;
    private final String text;
    private final HttpHeaders headers;

    public StaticResponseHandler(int status, String text, HttpHeaders headers) {
        this.status = status;
        this.text = text != null ? text : "";
        this.headers = headers != null ? headers : new HttpHeaders.Builder().build();
    }

    public Eventual<LiveHttpResponse> handle(LiveHttpRequest request, HttpInterceptor.Context context) {
        return Eventual.of((Object)LiveHttpResponse.response((HttpResponseStatus)HttpResponseStatus.statusWithCode((int)this.status)).body(new ByteStream((Publisher)Flux.just((Object)new Buffer(this.text, StandardCharsets.UTF_8)))).headers(this.headers).build());
    }

    public static class Factory
    implements RoutingObjectFactory {
        @Override
        public RoutingObject build(List<String> fullName, RoutingObjectFactory.Context context, StyxObjectDefinition configBlock) {
            Objects.requireNonNull(configBlock.config());
            StaticResponseConfig config = new JsonNodeConfig(configBlock.config()).as(StaticResponseConfig.class);
            HttpHeaders httpHeaders = this.buildHttpHeaders(config);
            return new StaticResponseHandler(config.status, config.response, httpHeaders);
        }

        private HttpHeaders buildHttpHeaders(StaticResponseConfig config) {
            List headerConfig = config.headers == null ? Collections.emptyList() : config.headers;
            HttpHeaders.Builder headersBuilder = new HttpHeaders.Builder();
            for (HttpHeaderConfig header : headerConfig) {
                headersBuilder.add((CharSequence)header.name, header.value);
            }
            return headersBuilder.build();
        }
    }

    private static class HttpHeaderConfig {
        private String name;
        private String value;

        public HttpHeaderConfig(@JsonProperty(value="name") String name, @JsonProperty(value="value") String value) {
            this.name = name;
            this.value = value;
        }
    }

    private static class StaticResponseConfig {
        private final int status;
        private final String response;
        private final List<HttpHeaderConfig> headers;

        public StaticResponseConfig(@JsonProperty(value="status") int status, @JsonProperty(value="content") String content, @JsonProperty(value="headers") List<HttpHeaderConfig> headers) {
            this.status = status;
            this.response = content;
            this.headers = headers;
        }
    }
}

