/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.routing.interceptors;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import com.hotels.styx.api.Eventual;
import com.hotels.styx.api.HttpInterceptor;
import com.hotels.styx.api.LiveHttpRequest;
import com.hotels.styx.api.LiveHttpResponse;
import com.hotels.styx.api.extension.service.RewriteConfig;
import com.hotels.styx.client.RewriteRuleset;
import com.hotels.styx.config.schema.Schema;
import com.hotels.styx.config.schema.SchemaDirective;
import com.hotels.styx.config.schema.SchemaDsl;
import com.hotels.styx.infrastructure.configuration.yaml.JsonNodeConfig;
import com.hotels.styx.routing.config.HttpInterceptorFactory;
import com.hotels.styx.routing.config.StyxObjectDefinition;
import java.util.List;

public class RewriteInterceptor
implements HttpInterceptor {
    public static final Schema.FieldType SCHEMA = SchemaDsl.list((Schema.FieldType)SchemaDsl.object((SchemaDirective[])new SchemaDirective[]{SchemaDsl.field((String)"urlPattern", (Schema.FieldType)SchemaDsl.string()), SchemaDsl.field((String)"replacement", (Schema.FieldType)SchemaDsl.string())}));
    private final RewriteRuleset rewriteRuleset;

    private RewriteInterceptor(RewriteRuleset rewriteRuleset) {
        this.rewriteRuleset = rewriteRuleset;
    }

    public Eventual<LiveHttpResponse> intercept(LiveHttpRequest request, HttpInterceptor.Chain chain) {
        return chain.proceed(this.rewriteRuleset.rewrite(request));
    }

    public static class Factory
    implements HttpInterceptorFactory {
        @Override
        public HttpInterceptor build(StyxObjectDefinition configBlock) {
            ImmutableList.Builder rules = ImmutableList.builder();
            configBlock.config().iterator().forEachRemaining(node -> {
                RewriteConfig rewriteConfig = new JsonNodeConfig((JsonNode)node).as(RewriteConfig.class);
                rules.add((Object)rewriteConfig);
            });
            return new RewriteInterceptor(new RewriteRuleset((List)rules.build()));
        }
    }
}

