/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.servers;

import com.fasterxml.jackson.databind.JsonNode;
import com.hotels.styx.Environment;
import com.hotels.styx.InetServer;
import com.hotels.styx.NettyExecutor;
import com.hotels.styx.ProxyConnectorFactory;
import com.hotels.styx.ResponseInfoFormat;
import com.hotels.styx.StyxObjectRecord;
import com.hotels.styx.api.Eventual;
import com.hotels.styx.api.HttpHandler;
import com.hotels.styx.api.HttpInterceptor;
import com.hotels.styx.api.LiveHttpRequest;
import com.hotels.styx.api.LiveHttpResponse;
import com.hotels.styx.infrastructure.configuration.yaml.JsonNodeConfig;
import com.hotels.styx.proxy.ProxyServerConfig;
import com.hotels.styx.routing.config.RoutingObjectFactory;
import com.hotels.styx.routing.config.StyxObjectReference;
import com.hotels.styx.routing.db.StyxObjectStore;
import com.hotels.styx.server.ConnectorConfig;
import com.hotels.styx.server.HttpConnectorConfig;
import com.hotels.styx.server.HttpsConnectorConfig;
import com.hotels.styx.server.netty.NettyServerBuilder;
import com.hotels.styx.server.netty.connectors.ResponseEnhancer;
import com.hotels.styx.servers.StyxHttpServerConfiguration;
import com.hotels.styx.serviceproviders.StyxServerFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\r0\fH\u0016J\u0018\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000f2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/hotels/styx/servers/StyxHttpServerFactory;", "Lcom/hotels/styx/serviceproviders/StyxServerFactory;", "()V", "create", "Lcom/hotels/styx/InetServer;", "name", "", "context", "Lcom/hotels/styx/routing/config/RoutingObjectFactory$Context;", "configuration", "Lcom/fasterxml/jackson/databind/JsonNode;", "serverDb", "Lcom/hotels/styx/routing/db/StyxObjectStore;", "Lcom/hotels/styx/StyxObjectRecord;", "serverConfig", "Lcom/hotels/styx/servers/StyxHttpServerConfiguration;", "kotlin.jvm.PlatformType", "styx-proxy"})
public final class StyxHttpServerFactory
implements StyxServerFactory {
    private final StyxHttpServerConfiguration serverConfig(JsonNode configuration) {
        return new JsonNodeConfig(configuration).as(StyxHttpServerConfiguration.class);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public InetServer create(@NotNull String name, @NotNull RoutingObjectFactory.Context context, @NotNull JsonNode configuration, @NotNull StyxObjectStore<StyxObjectRecord<InetServer>> serverDb) {
        HttpConnectorConfig httpConnectorConfig;
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull(serverDb, (String)"serverDb");
        StyxHttpServerConfiguration config = this.serverConfig(configuration);
        Environment environment = context.environment();
        NettyExecutor bossExecutor2 = (NettyExecutor)((StyxObjectRecord)context.executors().get(config.getBossExecutor()).orElseThrow(new Supplier<X>(name, config){
            final /* synthetic */ String $name;
            final /* synthetic */ StyxHttpServerConfiguration $config;

            @NotNull
            public final IllegalArgumentException get() {
                return new IllegalArgumentException("StyxHttpServer(" + this.$name + ") configuration error: bossExecutor='" + this.$config.getBossExecutor() + "' not declared.");
            }
            {
                this.$name = string;
                this.$config = styxHttpServerConfiguration;
            }
        })).getStyxService();
        NettyExecutor workerExecutor2 = (NettyExecutor)((StyxObjectRecord)context.executors().get(config.getWorkerExecutor()).orElseThrow(new Supplier<X>(name, config){
            final /* synthetic */ String $name;
            final /* synthetic */ StyxHttpServerConfiguration $config;

            @NotNull
            public final IllegalArgumentException get() {
                return new IllegalArgumentException("StyxHttpServer(" + this.$name + ") configuration error: workerExecutor='" + this.$config.getWorkerExecutor() + "' not declared.");
            }
            {
                this.$name = string;
                this.$config = styxHttpServerConfiguration;
            }
        })).getStyxService();
        NettyServerBuilder nettyServerBuilder = new NettyServerBuilder().setMetricsRegistry(environment.metricRegistry());
        ProxyConnectorFactory proxyConnectorFactory = new ProxyConnectorFactory(new ProxyServerConfig.Builder().setCompressResponses(config.getCompressResponses()).setMaxInitialLength(config.getMaxInitialLength()).setMaxHeaderSize(config.getMaxHeaderSize()).setMaxChunkSize(config.getMaxChunkSize()).setRequestTimeoutMillis(config.getRequestTimeoutMillis()).setKeepAliveTimeoutMillis(config.getKeepAliveTimeoutMillis()).setMaxConnectionsCount(config.getMaxConnectionsCount()).build(), environment.metricRegistry(), environment.errorListener(), environment.configuration().get("url.encoding.unwiseCharactersToEncode").orElse(""), new ResponseEnhancer(environment){
            final /* synthetic */ Environment $environment;

            public final LiveHttpResponse.Transformer enhance(LiveHttpResponse.Transformer builder, LiveHttpRequest request) {
                return builder.header(this.$environment.configuration().styxHeaderConfig().styxInfoHeaderName(), (Object)new ResponseInfoFormat(this.$environment).format(request));
            }
            {
                this.$environment = environment;
            }
        }, false, environment.httpMessageFormatter(), null);
        if (config.getTlsSettings() == null) {
            httpConnectorConfig = new HttpConnectorConfig(Integer.valueOf(config.getPort()));
        } else {
            void $this$toTypedArray$iv;
            Collection collection = config.getTlsSettings().getProtocols();
            HttpsConnectorConfig.Builder builder = new HttpsConnectorConfig.Builder().port(config.getPort()).sslProvider(config.getTlsSettings().getSslProvider()).certificateFile(config.getTlsSettings().getCertificateFile()).certificateKeyFile(config.getTlsSettings().getCertificateKeyFile()).cipherSuites(config.getTlsSettings().getCipherSuites());
            ProxyConnectorFactory proxyConnectorFactory2 = proxyConnectorFactory;
            NettyServerBuilder nettyServerBuilder2 = nettyServerBuilder;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] stringArray2 = stringArray;
            nettyServerBuilder = nettyServerBuilder2;
            proxyConnectorFactory = proxyConnectorFactory2;
            httpConnectorConfig = (HttpConnectorConfig)builder.protocols(Arrays.copyOf(stringArray2, stringArray2.length)).build();
        }
        InetServer inetServer = nettyServerBuilder.setProtocolConnector(proxyConnectorFactory.create((ConnectorConfig)httpConnectorConfig)).bossExecutor(bossExecutor2).workerExecutor(workerExecutor2).handler(new HttpHandler(context, config){
            final /* synthetic */ RoutingObjectFactory.Context $context;
            final /* synthetic */ StyxHttpServerConfiguration $config;

            public final Eventual<LiveHttpResponse> handle(LiveHttpRequest request, HttpInterceptor.Context ctx) {
                return this.$context.refLookup().apply(new StyxObjectReference(this.$config.getHandler())).handle(request, ctx);
            }
            {
                this.$context = context;
                this.$config = styxHttpServerConfiguration;
            }
        }).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)inetServer, (String)"NettyServerBuilder()\n   \u2026\n                .build()");
        return inetServer;
    }
}

