/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.serviceproviders;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.hotels.styx.api.Environment;
import com.hotels.styx.api.configuration.Configuration;
import com.hotels.styx.api.configuration.ConfigurationException;
import com.hotels.styx.api.configuration.ServiceFactory;
import com.hotels.styx.api.extension.ActiveOrigins;
import com.hotels.styx.api.extension.loadbalancing.spi.LoadBalancer;
import com.hotels.styx.api.extension.loadbalancing.spi.LoadBalancerFactory;
import com.hotels.styx.api.extension.retrypolicy.spi.RetryPolicy;
import com.hotels.styx.api.extension.retrypolicy.spi.RetryPolicyFactory;
import com.hotels.styx.common.Pair;
import com.hotels.styx.infrastructure.configuration.yaml.JsonNodeConfig;
import com.hotels.styx.proxy.ClassFactories;
import com.hotels.styx.spi.ExtensionObjectFactory;
import com.hotels.styx.spi.config.ServiceFactoryConfig;
import com.hotels.styx.spi.config.SpiExtension;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceProvision {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceProvision.class);

    private ServiceProvision() {
    }

    public static <E extends LoadBalancer> Optional<E> loadLoadBalancer(Configuration configuration, Environment environment, String key, Class<? extends E> serviceClass, ActiveOrigins activeOrigins) {
        return configuration.get(key, ServiceFactoryConfig.class).map(factoryConfig -> {
            try {
                LoadBalancerFactory factory = ClassFactories.newInstance(factoryConfig.factory(), LoadBalancerFactory.class);
                return (LoadBalancer)serviceClass.cast(factory.create(environment, (Configuration)factoryConfig.config(), activeOrigins));
            }
            catch (Exception e) {
                throw new ConfigurationException("Error creating service", (Throwable)e);
            }
        });
    }

    public static <E extends RetryPolicy> Optional<E> loadRetryPolicy(Configuration configuration, Environment environment, String key, Class<? extends E> serviceClass) {
        return configuration.get(key, ServiceFactoryConfig.class).map(factoryConfig -> {
            RetryPolicyFactory factory = ClassFactories.newInstance(factoryConfig.factory(), RetryPolicyFactory.class);
            JsonNodeConfig config = factoryConfig.config();
            return (RetryPolicy)serviceClass.cast(factory.create(environment, (Configuration)config));
        });
    }

    public static <T> Map<String, T> loadServices(Configuration configuration, Environment environment, String key, Class<? extends T> serviceClass) {
        return configuration.get(key, JsonNode.class).map(node -> ServiceProvision.servicesMap(node, environment, serviceClass)).orElse(Collections.emptyMap());
    }

    private static <U> Map<String, U> servicesMap(JsonNode jsonNode, Environment environment, Class<? extends U> serviceClass) {
        JsonNode factories = jsonNode.get("factories");
        JsonNodeConfig jsonNodeConfig = new JsonNodeConfig(factories);
        return Lists.newArrayList((Iterator)factories.fieldNames()).stream().flatMap(name -> {
            if (ServiceProvision.isType(name, jsonNodeConfig, SpiExtension.class)) {
                return ServiceProvision.namedExtensionFromSpiExtension(environment, serviceClass, jsonNodeConfig, name);
            }
            if (ServiceProvision.isType(name, jsonNodeConfig, ServiceFactoryConfig.class)) {
                return ServiceProvision.namedExtensionFromServiceFactoryConfig(environment, serviceClass, jsonNodeConfig, name);
            }
            String content = factories.get(name).toString();
            String message = String.format("Unexpected configuration object 'services.factories.%s', Configuration='%s'", name, content);
            throw new ConfigurationException(message);
        }).collect(Collectors.toMap(Pair::key, Pair::value));
    }

    private static <T> boolean isType(String name, JsonNodeConfig jsonNodeConfig, Class<T> nodeType) {
        try {
            jsonNodeConfig.get(name, nodeType);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static <U> Stream<Pair<String, ? extends U>> namedExtensionFromSpiExtension(Environment environment, Class<? extends U> serviceClass, JsonNodeConfig jsonNodeConfig, String name) {
        LOGGER.info("Spi Extension type");
        return jsonNodeConfig.get(name, SpiExtension.class).filter(SpiExtension::enabled).map(extension -> ServiceProvision.loadSpiExtension(extension, environment, serviceClass)).map(service -> ImmutableList.of((Object)Pair.pair((Object)name, (Object)service))).orElse(ImmutableList.of()).stream();
    }

    private static <T> T loadSpiExtension(SpiExtension factoryConfig, Environment environment, Class<T> serviceSuperclass) {
        ServiceFactory factory = ServiceProvision.newServiceFactory(factoryConfig);
        JsonNodeConfig config = new JsonNodeConfig(factoryConfig.config());
        return serviceSuperclass.cast(factory.create(environment, (Configuration)config));
    }

    private static ServiceFactory newServiceFactory(SpiExtension extensionConfig) {
        try {
            return ExtensionObjectFactory.EXTENSION_OBJECT_FACTORY.newInstance(extensionConfig.factory(), ServiceFactory.class);
        }
        catch (Exception e) {
            throw new ConfigurationException(String.format("Could not load a service factory for configuration=%s", extensionConfig), (Throwable)e);
        }
    }

    private static <U> Stream<Pair<String, ? extends U>> namedExtensionFromServiceFactoryConfig(Environment environment, Class<? extends U> serviceClass, JsonNodeConfig jsonNodeConfig, String name) {
        LOGGER.info("Service Factory Config type");
        return jsonNodeConfig.get(name, ServiceFactoryConfig.class).filter(ServiceFactoryConfig::enabled).map(serviceFactoryConfig -> ServiceProvision.loadServiceFactory(serviceFactoryConfig, environment, serviceClass)).map(service -> ImmutableList.of((Object)Pair.pair((Object)name, (Object)service))).orElse(ImmutableList.of()).stream();
    }

    private static <T> T loadServiceFactory(ServiceFactoryConfig serviceFactoryConfig, Environment environment, Class<T> serviceSuperclass) {
        ServiceFactory factory = ClassFactories.newInstance(serviceFactoryConfig.factory(), ServiceFactory.class);
        JsonNodeConfig config = serviceFactoryConfig.config();
        return serviceSuperclass.cast(factory.create(environment, (Configuration)config));
    }
}

